/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep.eval;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scijava.sjep.Tokens;
import org.scijava.sjep.eval.DefaultEvaluator;
import org.scijava.sjep.eval.Evaluator;

public class EvaluatorConsole {
    private static final String PROMPT = "> ";
    private final Evaluator evaluator;

    public EvaluatorConsole() {
        this(new DefaultEvaluator());
    }

    public EvaluatorConsole(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void showConsole() throws IOException {
        this.showConsole(new BufferedReader(new InputStreamReader(System.in)));
    }

    public void showConsole(BufferedReader in) throws IOException {
        while (true) {
            this.print(PROMPT);
            String line = in.readLine();
            if (line == null) break;
            try {
                Object result = this.evaluator.evaluate(line);
                if (Tokens.isVariable(result)) {
                    this.println(result + " = " + this.evaluator.value(result));
                    continue;
                }
                this.println(result);
            }
            catch (IllegalArgumentException exc) {
                String msg = exc.getMessage();
                if (msg == null) {
                    throw exc;
                }
                Matcher m = Pattern.compile(".* at index (\\d+)").matcher(msg);
                if (m.matches()) {
                    int index = Integer.parseInt(m.group(1));
                    this.println(EvaluatorConsole.caret(index));
                }
                this.println(msg);
            }
        }
    }

    public void print(Object o) {
        System.out.print(o);
    }

    public void println(Object o) {
        System.out.println(o);
    }

    private static String caret(int index) {
        StringBuilder sb = new StringBuilder();
        int count = PROMPT.length() + index;
        for (int i = 0; i < count; ++i) {
            sb.append(" ");
        }
        sb.append("^");
        return sb.toString();
    }
}

