/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.sjep.AbstractTest;
import org.scijava.sjep.ExpressionParser;
import org.scijava.sjep.Operator;
import org.scijava.sjep.Operators;

public class ExpressionParserTest
extends AbstractTest {
    @Test
    public void testStrings() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("'hello'*\"world\"");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)3L, (long)queue.size());
        this.assertString("hello", queue.pop());
        this.assertString("world", queue.pop());
        Assert.assertSame((Object)Operators.MUL, queue.pop());
    }

    @Test
    public void testNumbers() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("1.1+2L+3f+4-+5d-6");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)11L, (long)queue.size());
        this.assertNumber(1.1, queue.pop());
        this.assertNumber(2L, queue.pop());
        Assert.assertSame((Object)Operators.ADD, queue.pop());
        this.assertNumber(Float.valueOf(3.0f), queue.pop());
        Assert.assertSame((Object)Operators.ADD, queue.pop());
        this.assertNumber(4, queue.pop());
        Assert.assertSame((Object)Operators.ADD, queue.pop());
        this.assertNumber(5.0, queue.pop());
        Assert.assertSame((Object)Operators.SUB, queue.pop());
        this.assertNumber(6, queue.pop());
        Assert.assertSame((Object)Operators.SUB, queue.pop());
    }

    @Test
    public void testOperatorsIndividual() {
        ExpressionParser p = new ExpressionParser();
        this.assertBinary(p, "a", Operators.DOT, "b", "a.b");
        this.assertUnary(p, "a", Operators.TRANSPOSE, "a'");
        this.assertUnary(p, "a", Operators.DOT_TRANSPOSE, "a.'");
        this.assertBinary(p, "a", Operators.POW, "b", "a^b");
        this.assertBinary(p, "a", Operators.DOT_POW, "b", "a.^b");
        this.assertUnary(p, "a", Operators.PRE_INC, "++a");
        this.assertUnary(p, "a", Operators.POST_INC, "a++");
        this.assertUnary(p, "a", Operators.PRE_DEC, "--a");
        this.assertUnary(p, "a", Operators.POST_DEC, "a--");
        this.assertUnary(p, "a", Operators.POS, "+a");
        this.assertUnary(p, "a", Operators.NEG, "-a");
        this.assertUnary(p, "a", Operators.COMPLEMENT, "~a");
        this.assertUnary(p, "a", Operators.NOT, "!a");
        this.assertBinary(p, "a", Operators.MUL, "b", "a*b");
        this.assertBinary(p, "a", Operators.DIV, "b", "a/b");
        this.assertBinary(p, "a", Operators.MOD, "b", "a%b");
        this.assertBinary(p, "a", Operators.ADD, "b", "a+b");
        this.assertBinary(p, "a", Operators.SUB, "b", "a-b");
        this.assertBinary(p, "a", Operators.LEFT_SHIFT, "b", "a<<b");
        this.assertBinary(p, "a", Operators.RIGHT_SHIFT, "b", "a>>b");
        this.assertBinary(p, "a", Operators.UNSIGNED_RIGHT_SHIFT, "b", "a>>>b");
        this.assertBinary(p, "a", Operators.COLON, "b", "a:b");
        this.assertBinary(p, "a", Operators.LESS_THAN, "b", "a<b");
        this.assertBinary(p, "a", Operators.GREATER_THAN, "b", "a>b");
        this.assertBinary(p, "a", Operators.LESS_THAN_OR_EQUAL, "b", "a<=b");
        this.assertBinary(p, "a", Operators.GREATER_THAN_OR_EQUAL, "b", "a>=b");
        this.assertBinary(p, "a", Operators.INSTANCEOF, "b", "a instanceof b");
        this.assertBinary(p, "a", Operators.EQUAL, "b", "a==b");
        this.assertBinary(p, "a", Operators.NOT_EQUAL, "b", "a!=b");
        this.assertBinary(p, "a", Operators.BITWISE_AND, "b", "a&b");
        this.assertBinary(p, "a", Operators.BITWISE_OR, "b", "a|b");
        this.assertBinary(p, "a", Operators.LOGICAL_AND, "b", "a&&b");
        this.assertBinary(p, "a", Operators.LOGICAL_OR, "b", "a||b");
        this.assertBinary(p, "a", Operators.ASSIGN, "b", "a=b");
        this.assertBinary(p, "a", Operators.POW_ASSIGN, "b", "a^=b");
        this.assertBinary(p, "a", Operators.DOT_POW_ASSIGN, "b", "a.^=b");
        this.assertBinary(p, "a", Operators.MUL_ASSIGN, "b", "a*=b");
        this.assertBinary(p, "a", Operators.DIV_ASSIGN, "b", "a/=b");
        this.assertBinary(p, "a", Operators.MOD_ASSIGN, "b", "a%=b");
        this.assertBinary(p, "a", Operators.RIGHT_DIV_ASSIGN, "b", "a\\=b");
        this.assertBinary(p, "a", Operators.DOT_DIV_ASSIGN, "b", "a./=b");
        this.assertBinary(p, "a", Operators.DOT_RIGHT_DIV_ASSIGN, "b", "a.\\=b");
        this.assertBinary(p, "a", Operators.ADD_ASSIGN, "b", "a+=b");
        this.assertBinary(p, "a", Operators.SUB_ASSIGN, "b", "a-=b");
        this.assertBinary(p, "a", Operators.AND_ASSIGN, "b", "a&=b");
        this.assertBinary(p, "a", Operators.OR_ASSIGN, "b", "a|=b");
        this.assertBinary(p, "a", Operators.LEFT_SHIFT_ASSIGN, "b", "a<<=b");
        this.assertBinary(p, "a", Operators.RIGHT_SHIFT_ASSIGN, "b", "a>>=b");
        this.assertBinary(p, "a", Operators.UNSIGNED_RIGHT_SHIFT_ASSIGN, "b", "a>>>=b");
    }

    @Test
    public void testMathOperators() {
        String expression = "(a|=b)|(c&=d)&(e>>>=f)>>>(g>>=h)>>(i<<=j)<<(k-=l)-(m+=n)+(o.\\=p).\\(q./=r)./(s\\=t)\\(u%=v)%(w/=x)/(y*=z)*(aa.^=bb).^(cc^=dd)^f(~ee--,-ff++,+--gg',++hh.')";
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("(a|=b)|(c&=d)&(e>>>=f)>>>(g>>=h)>>(i<<=j)<<(k-=l)-(m+=n)+(o.\\=p).\\(q./=r)./(s\\=t)\\(u%=v)%(w/=x)/(y*=z)*(aa.^=bb).^(cc^=dd)^f(~ee--,-ff++,+--gg',++hh.')");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)91L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.OR_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertVariable("d", queue.pop());
        Assert.assertSame((Object)Operators.AND_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertVariable("e", queue.pop());
        this.assertVariable("f", queue.pop());
        Assert.assertSame((Object)Operators.UNSIGNED_RIGHT_SHIFT_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertVariable("g", queue.pop());
        this.assertVariable("h", queue.pop());
        Assert.assertSame((Object)Operators.RIGHT_SHIFT_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        Assert.assertSame((Object)Operators.UNSIGNED_RIGHT_SHIFT, queue.pop());
        this.assertVariable("i", queue.pop());
        this.assertVariable("j", queue.pop());
        Assert.assertSame((Object)Operators.LEFT_SHIFT_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        Assert.assertSame((Object)Operators.RIGHT_SHIFT, queue.pop());
        this.assertVariable("k", queue.pop());
        this.assertVariable("l", queue.pop());
        Assert.assertSame((Object)Operators.SUB_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertVariable("m", queue.pop());
        this.assertVariable("n", queue.pop());
        Assert.assertSame((Object)Operators.ADD_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        Assert.assertSame((Object)Operators.SUB, queue.pop());
        this.assertVariable("o", queue.pop());
        this.assertVariable("p", queue.pop());
        Assert.assertSame((Object)Operators.DOT_RIGHT_DIV_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertVariable("q", queue.pop());
        this.assertVariable("r", queue.pop());
        Assert.assertSame((Object)Operators.DOT_DIV_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        Assert.assertSame((Object)Operators.DOT_RIGHT_DIV, queue.pop());
        this.assertVariable("s", queue.pop());
        this.assertVariable("t", queue.pop());
        Assert.assertSame((Object)Operators.RIGHT_DIV_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        Assert.assertSame((Object)Operators.DOT_DIV, queue.pop());
        this.assertVariable("u", queue.pop());
        this.assertVariable("v", queue.pop());
        Assert.assertSame((Object)Operators.MOD_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        Assert.assertSame((Object)Operators.RIGHT_DIV, queue.pop());
        this.assertVariable("w", queue.pop());
        this.assertVariable("x", queue.pop());
        Assert.assertSame((Object)Operators.DIV_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        Assert.assertSame((Object)Operators.MOD, queue.pop());
        this.assertVariable("y", queue.pop());
        this.assertVariable("z", queue.pop());
        Assert.assertSame((Object)Operators.MUL_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        Assert.assertSame((Object)Operators.DIV, queue.pop());
        this.assertVariable("aa", queue.pop());
        this.assertVariable("bb", queue.pop());
        Assert.assertSame((Object)Operators.DOT_POW_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertVariable("cc", queue.pop());
        this.assertVariable("dd", queue.pop());
        Assert.assertSame((Object)Operators.POW_ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertVariable("f", queue.pop());
        this.assertVariable("ee", queue.pop());
        Assert.assertSame((Object)Operators.POST_DEC, queue.pop());
        Assert.assertSame((Object)Operators.COMPLEMENT, queue.pop());
        this.assertVariable("ff", queue.pop());
        Assert.assertSame((Object)Operators.POST_INC, queue.pop());
        Assert.assertSame((Object)Operators.NEG, queue.pop());
        this.assertVariable("gg", queue.pop());
        Assert.assertSame((Object)Operators.TRANSPOSE, queue.pop());
        Assert.assertSame((Object)Operators.PRE_DEC, queue.pop());
        Assert.assertSame((Object)Operators.POS, queue.pop());
        this.assertVariable("hh", queue.pop());
        Assert.assertSame((Object)Operators.DOT_TRANSPOSE, queue.pop());
        Assert.assertSame((Object)Operators.PRE_INC, queue.pop());
        this.assertGroup(Operators.PARENS, 4, queue.pop());
        this.assertFunction(queue.pop());
        Assert.assertSame((Object)Operators.POW, queue.pop());
        Assert.assertSame((Object)Operators.DOT_POW, queue.pop());
        Assert.assertSame((Object)Operators.MUL, queue.pop());
        Assert.assertSame((Object)Operators.ADD, queue.pop());
        Assert.assertSame((Object)Operators.LEFT_SHIFT, queue.pop());
        Assert.assertSame((Object)Operators.BITWISE_AND, queue.pop());
        Assert.assertSame((Object)Operators.BITWISE_OR, queue.pop());
    }

    public void testLogicOperators() {
        String expression = "a<b || c>d && e<=f || g>=h && i==j || k!=l && m instanceof n || !o";
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a<b || c>d && e<=f || g>=h && i==j || k!=l && m instanceof n || !o");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)30L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.LESS_THAN, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertVariable("d", queue.pop());
        Assert.assertSame((Object)Operators.GREATER_THAN, queue.pop());
        this.assertVariable("e", queue.pop());
        this.assertVariable("f", queue.pop());
        Assert.assertSame((Object)Operators.LESS_THAN_OR_EQUAL, queue.pop());
        Assert.assertSame((Object)Operators.LOGICAL_AND, queue.pop());
        Assert.assertSame((Object)Operators.LOGICAL_OR, queue.pop());
        this.assertVariable("g", queue.pop());
        this.assertVariable("h", queue.pop());
        Assert.assertSame((Object)Operators.GREATER_THAN_OR_EQUAL, queue.pop());
        this.assertVariable("i", queue.pop());
        this.assertVariable("j", queue.pop());
        Assert.assertSame((Object)Operators.EQUAL, queue.pop());
        Assert.assertSame((Object)Operators.LOGICAL_AND, queue.pop());
        Assert.assertSame((Object)Operators.LOGICAL_OR, queue.pop());
        this.assertVariable("k", queue.pop());
        this.assertVariable("l", queue.pop());
        Assert.assertSame((Object)Operators.NOT_EQUAL, queue.pop());
        this.assertVariable("m", queue.pop());
        this.assertVariable("n", queue.pop());
        Assert.assertSame((Object)Operators.INSTANCEOF, queue.pop());
        Assert.assertSame((Object)Operators.LOGICAL_AND, queue.pop());
        Assert.assertSame((Object)Operators.LOGICAL_OR, queue.pop());
        this.assertVariable("0", queue.pop());
        Assert.assertSame((Object)Operators.NOT, queue.pop());
        Assert.assertSame((Object)Operators.LOGICAL_OR, queue.pop());
    }

    @Test
    public void testUnaryOperators1() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("-+a");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)3L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        Assert.assertSame((Object)Operators.POS, queue.pop());
        Assert.assertSame((Object)Operators.NEG, queue.pop());
    }

    @Test
    public void testUnaryOperators2() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a+-b");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)4L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.NEG, queue.pop());
        Assert.assertSame((Object)Operators.ADD, queue.pop());
    }

    @Test
    public void testUnaryOperators3() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a-+-b");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)5L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.NEG, queue.pop());
        Assert.assertSame((Object)Operators.POS, queue.pop());
        Assert.assertSame((Object)Operators.SUB, queue.pop());
    }

    @Test
    public void testUnaryOperators4() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("-+a-+-b");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)7L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        Assert.assertSame((Object)Operators.POS, queue.pop());
        Assert.assertSame((Object)Operators.NEG, queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.NEG, queue.pop());
        Assert.assertSame((Object)Operators.POS, queue.pop());
        Assert.assertSame((Object)Operators.SUB, queue.pop());
    }

    @Test
    public void testNullaryGroup() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("()");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)1L, (long)queue.size());
        this.assertGroup(Operators.PARENS, 0, queue.pop());
    }

    @Test
    public void testUnaryGroup() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("(a)");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)2L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
    }

    @Test
    public void testNestedGroups() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("(())");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)2L, (long)queue.size());
        this.assertGroup(Operators.PARENS, 0, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
    }

    @Test
    public void testNullaryFunction() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("f()");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)3L, (long)queue.size());
        this.assertVariable("f", queue.pop());
        this.assertGroup(Operators.PARENS, 0, queue.pop());
        this.assertFunction(queue.pop());
    }

    @Test
    public void testUnaryFunction() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("f(a)");
        Assert.assertNotNull((Object)queue);
        this.assertVariable("f", queue.pop());
        this.assertVariable("a", queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertFunction(queue.pop());
    }

    @Test
    public void testBinaryFunction() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("f(a,b)");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)5L, (long)queue.size());
        this.assertVariable("f", queue.pop());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        this.assertGroup(Operators.PARENS, 2, queue.pop());
        this.assertFunction(queue.pop());
    }

    @Test
    public void testTernaryFunction() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("f(a,b,c)");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)6L, (long)queue.size());
        this.assertVariable("f", queue.pop());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertGroup(Operators.PARENS, 3, queue.pop());
        this.assertFunction(queue.pop());
    }

    @Test
    public void testNestedFunctions() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("f(g(),a,h(b),i(c,d))");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)16L, (long)queue.size());
        this.assertVariable("f", queue.pop());
        this.assertVariable("g", queue.pop());
        this.assertGroup(Operators.PARENS, 0, queue.pop());
        this.assertFunction(queue.pop());
        this.assertVariable("a", queue.pop());
        this.assertVariable("h", queue.pop());
        this.assertVariable("b", queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertFunction(queue.pop());
        this.assertVariable("i", queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertVariable("d", queue.pop());
        this.assertGroup(Operators.PARENS, 2, queue.pop());
        this.assertFunction(queue.pop());
        this.assertGroup(Operators.PARENS, 4, queue.pop());
        this.assertFunction(queue.pop());
    }

    @Test
    public void testFunctionParens1() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a.b(c)");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)6L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.DOT, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertFunction(queue.pop());
    }

    @Test
    public void testFunctionParens2() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a(b).c");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)6L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertFunction(queue.pop());
        this.assertVariable("c", queue.pop());
        Assert.assertSame((Object)Operators.DOT, queue.pop());
    }

    @Test
    public void testFunctionParens3() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a.b(c).d");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)8L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.DOT, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertFunction(queue.pop());
        this.assertVariable("d", queue.pop());
        Assert.assertSame((Object)Operators.DOT, queue.pop());
    }

    @Test
    public void testFunctionParens4() {
        List operators = Operators.standardList();
        Operator atOp = new Operator("@", 2, Operator.Associativity.LEFT, 100.0);
        operators.add(atOp);
        ExpressionParser parser = new ExpressionParser((Collection)operators);
        LinkedList queue = parser.parsePostfix("a@b(c)@d");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)8L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)atOp, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertVariable("d", queue.pop());
        Assert.assertSame((Object)atOp, queue.pop());
        this.assertFunction(queue.pop());
    }

    @Test
    public void testFunctionBrackets1() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a.b[c]");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)6L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.DOT, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertGroup(Operators.BRACKETS, 1, queue.pop());
        this.assertFunction(queue.pop());
    }

    @Test
    public void testFunctionBrackets2() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a[b].c");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)6L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        this.assertGroup(Operators.BRACKETS, 1, queue.pop());
        this.assertFunction(queue.pop());
        this.assertVariable("c", queue.pop());
        Assert.assertSame((Object)Operators.DOT, queue.pop());
    }

    @Test
    public void testFunctionBrackets3() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a.b[c].d");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)8L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.DOT, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertGroup(Operators.BRACKETS, 1, queue.pop());
        this.assertFunction(queue.pop());
        this.assertVariable("d", queue.pop());
        Assert.assertSame((Object)Operators.DOT, queue.pop());
    }

    @Test
    public void testFunctionBrackets4() {
        List operators = Operators.standardList();
        Operator atOp = new Operator("@", 2, Operator.Associativity.LEFT, 100.0);
        operators.add(atOp);
        ExpressionParser parser = new ExpressionParser((Collection)operators);
        LinkedList queue = parser.parsePostfix("a@b[c]@d");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)8L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)atOp, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertGroup(Operators.BRACKETS, 1, queue.pop());
        this.assertVariable("d", queue.pop());
        Assert.assertSame((Object)atOp, queue.pop());
        this.assertFunction(queue.pop());
    }

    @Test
    public void testFunctionBraces1() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a.b{c}");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)6L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.DOT, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertGroup(Operators.BRACES, 1, queue.pop());
        this.assertFunction(queue.pop());
    }

    @Test
    public void testFunctionBraces2() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a{b}.c");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)6L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        this.assertGroup(Operators.BRACES, 1, queue.pop());
        this.assertFunction(queue.pop());
        this.assertVariable("c", queue.pop());
        Assert.assertSame((Object)Operators.DOT, queue.pop());
    }

    @Test
    public void testFunctionBraces3() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a.b{c}.d");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)8L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.DOT, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertGroup(Operators.BRACES, 1, queue.pop());
        this.assertFunction(queue.pop());
        this.assertVariable("d", queue.pop());
        Assert.assertSame((Object)Operators.DOT, queue.pop());
    }

    @Test
    public void testFunctionBraces4() {
        List operators = Operators.standardList();
        Operator atOp = new Operator("@", 2, Operator.Associativity.LEFT, 100.0);
        operators.add(atOp);
        ExpressionParser parser = new ExpressionParser((Collection)operators);
        LinkedList queue = parser.parsePostfix("a@b{c}@d");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)8L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)atOp, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertGroup(Operators.BRACES, 1, queue.pop());
        this.assertVariable("d", queue.pop());
        Assert.assertSame((Object)atOp, queue.pop());
        this.assertFunction(queue.pop());
    }

    @Test
    public void testMixedFunctions() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a[b(c), d{3:4}, 2]");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)14L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertFunction(queue.pop());
        this.assertVariable("d", queue.pop());
        this.assertNumber(3, queue.pop());
        this.assertNumber(4, queue.pop());
        Assert.assertSame((Object)Operators.COLON, queue.pop());
        this.assertGroup(Operators.BRACES, 1, queue.pop());
        this.assertFunction(queue.pop());
        this.assertNumber(2, queue.pop());
        this.assertGroup(Operators.BRACKETS, 3, queue.pop());
        this.assertFunction(queue.pop());
    }

    @Test
    public void testParameterSyntax() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("(choices={'quick brown fox', 'lazy dog'}, persist=false, value=5)");
        Assert.assertNotNull((Object)queue);
        this.assertVariable("choices", queue.pop());
        this.assertString("quick brown fox", queue.pop());
        this.assertString("lazy dog", queue.pop());
        this.assertGroup(Operators.BRACES, 2, queue.pop());
        Assert.assertSame((Object)Operators.ASSIGN, queue.pop());
        this.assertVariable("persist", queue.pop());
        Assert.assertSame((Object)false, queue.pop());
        Assert.assertSame((Object)Operators.ASSIGN, queue.pop());
        this.assertVariable("value", queue.pop());
        this.assertNumber(5, queue.pop());
        Assert.assertSame((Object)Operators.ASSIGN, queue.pop());
        this.assertGroup(Operators.PARENS, 3, queue.pop());
    }

    @Test
    public void testNonFunctionGroup() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("f+(g)");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)4L, (long)queue.size());
        this.assertVariable("f", queue.pop());
        this.assertVariable("g", queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        Assert.assertSame((Object)Operators.ADD, queue.pop());
    }

    @Test
    public void testOperatorPrecedence() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a+b*c^d.^e'");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)10L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertVariable("d", queue.pop());
        this.assertVariable("e", queue.pop());
        Assert.assertSame((Object)Operators.DOT_POW, queue.pop());
        Assert.assertSame((Object)Operators.POW, queue.pop());
        Assert.assertSame((Object)Operators.TRANSPOSE, queue.pop());
        Assert.assertSame((Object)Operators.MUL, queue.pop());
        Assert.assertSame((Object)Operators.ADD, queue.pop());
    }

    @Test
    public void testOperatorAssociativity() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("(a/b/c)+(a^b^c)");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)13L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.DIV, queue.pop());
        this.assertVariable("c", queue.pop());
        Assert.assertSame((Object)Operators.DIV, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        this.assertVariable("c", queue.pop());
        Assert.assertSame((Object)Operators.POW, queue.pop());
        Assert.assertSame((Object)Operators.POW, queue.pop());
        this.assertGroup(Operators.PARENS, 1, queue.pop());
        Assert.assertSame((Object)Operators.ADD, queue.pop());
    }

    @Test
    public void testMultipleStatements() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a=1 ; b=2 ; c=3");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)9L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertNumber(1, queue.pop());
        Assert.assertSame((Object)Operators.ASSIGN, queue.pop());
        this.assertVariable("b", queue.pop());
        this.assertNumber(2, queue.pop());
        Assert.assertSame((Object)Operators.ASSIGN, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertNumber(3, queue.pop());
        Assert.assertSame((Object)Operators.ASSIGN, queue.pop());
    }

    @Test
    public void testParsePostfix() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a*b-c*a/func(quick,brown,fox)^foo^bar");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)18L, (long)queue.size());
        this.assertVariable("a", queue.pop());
        this.assertVariable("b", queue.pop());
        Assert.assertSame((Object)Operators.MUL, queue.pop());
        this.assertVariable("c", queue.pop());
        this.assertVariable("a", queue.pop());
        Assert.assertSame((Object)Operators.MUL, queue.pop());
        this.assertVariable("func", queue.pop());
        this.assertVariable("quick", queue.pop());
        this.assertVariable("brown", queue.pop());
        this.assertVariable("fox", queue.pop());
        this.assertGroup(Operators.PARENS, 3, queue.pop());
        this.assertFunction(queue.pop());
        this.assertVariable("foo", queue.pop());
        this.assertVariable("bar", queue.pop());
        Assert.assertSame((Object)Operators.POW, queue.pop());
        Assert.assertSame((Object)Operators.POW, queue.pop());
        Assert.assertSame((Object)Operators.DIV, queue.pop());
        Assert.assertSame((Object)Operators.SUB, queue.pop());
    }

    @Test
    public void testEmpty() {
        ExpressionParser parser = new ExpressionParser();
        Assert.assertEquals((long)0L, (long)parser.parsePostfix("").size());
    }

    @Test
    public void testInvalid() {
        ExpressionParser parser = new ExpressionParser();
        this.assertInvalid(parser, "a a", "Invalid character at index 2");
        this.assertInvalid(parser, "func(,)", "Invalid character at index 5");
        this.assertInvalid(parser, "foo,bar", "Misplaced separator or mismatched groups at index 4");
        this.assertInvalid(parser, "(", "Mismatched groups at index 1");
        this.assertInvalid(parser, ")", "Mismatched group terminator ')' at index 1");
        this.assertInvalid(parser, ")(", "Mismatched group terminator ')' at index 1");
        this.assertInvalid(parser, "(()", "Mismatched groups at index 3");
    }

    private void assertUnary(ExpressionParser parser, String var, Operator op, String expression) {
        LinkedList queue = parser.parsePostfix(expression);
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)2L, (long)queue.size());
        this.assertVariable(var, queue.pop());
        Assert.assertSame((Object)op, queue.pop());
    }

    private void assertBinary(ExpressionParser parser, String var1, Operator op, String var2, String expression) {
        LinkedList queue = parser.parsePostfix(expression);
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)3L, (long)queue.size());
        this.assertVariable(var1, queue.pop());
        this.assertVariable(var2, queue.pop());
        Assert.assertSame((Object)op, queue.pop());
    }

    private void assertInvalid(ExpressionParser parser, String expression, String message) {
        try {
            parser.parsePostfix(expression);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException exc) {
            Assert.assertEquals((Object)message, (Object)exc.getMessage());
        }
    }
}

