/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Binding;
import fit.Fixture;
import fit.Parse;
import fit.TypeAdapter;
import fit.exception.NoSuchFieldFitFailureException;
import fit.exception.NoSuchMethodFitFailureException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import util.GracefulNamer;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Binding {
    private static final Pattern regexMethodPattern = Pattern.compile("(.+)(?:\\?\\?|!!)");
    private static final Pattern methodPattern = Pattern.compile("(.+)(?:\\(\\)|\\?|!)");
    private static final Pattern fieldPattern = Pattern.compile("=?([^=]+)=?");
    public TypeAdapter adapter;

    public static Binding create(Fixture fixture, String name) throws Throwable {
        SaveBinding binding = null;
        if (name.startsWith("=")) {
            binding = new SaveBinding();
        } else if (name.endsWith("=")) {
            binding = new RecallBinding();
        } else if (regexMethodPattern.matcher(name).matches()) {
            binding = new RegexQueryBinding();
        } else if (methodPattern.matcher(name).matches()) {
            binding = new QueryBinding();
        } else if (fieldPattern.matcher(name).matches()) {
            binding = new SetBinding();
        }
        if (binding == null) {
            binding = new NullBinding();
        } else {
            binding.adapter = Binding.makeAdapter((Fixture)fixture, (String)name);
        }
        return binding;
    }

    private static TypeAdapter makeAdapter(Fixture fixture, String name) throws Throwable {
        Matcher regexMatcher = regexMethodPattern.matcher(name);
        if (regexMatcher.find()) {
            return Binding.makeAdapterForRegexMethod((String)name, (Fixture)fixture, (Matcher)regexMatcher);
        }
        Matcher methodMatcher = methodPattern.matcher(name);
        if (methodMatcher.find()) {
            return Binding.makeAdapterForMethod((String)name, (Fixture)fixture, (Matcher)methodMatcher);
        }
        return Binding.makeAdapterForField((String)name, (Fixture)fixture);
    }

    private static TypeAdapter makeAdapterForField(String name, Fixture fixture) {
        Field field = null;
        if (GracefulNamer.isGracefulName((String)name)) {
            String simpleName = GracefulNamer.disgrace((String)name).toLowerCase();
            field = Binding.findField((Fixture)fixture, (String)simpleName);
        } else {
            Matcher matcher = fieldPattern.matcher(name);
            matcher.find();
            String fieldName = matcher.group(1);
            Class clazz = fixture.getTargetClass();
            try {
                field = clazz.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                try {
                    field = Binding.getField((Class)clazz, (String)fieldName);
                }
                catch (NoSuchFieldException e2) {
                    // empty catch block
                }
            }
        }
        if (field == null) {
            throw new NoSuchFieldFitFailureException(name);
        }
        return TypeAdapter.on((Fixture)fixture, (Field)field);
    }

    private static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return Binding.getField(superClass, (String)fieldName);
        }
    }

    private static TypeAdapter makeAdapterForMethod(String name, Fixture fixture, Matcher matcher) {
        Method method = Binding.getMethod((String)name, (Fixture)fixture, (Matcher)matcher);
        if (method == null) {
            throw new NoSuchMethodFitFailureException(name);
        }
        return TypeAdapter.on((Fixture)fixture, (Method)method, (boolean)false);
    }

    private static TypeAdapter makeAdapterForRegexMethod(String name, Fixture fixture, Matcher matcher) {
        Method method = Binding.getMethod((String)name, (Fixture)fixture, (Matcher)matcher);
        if (method == null) {
            throw new NoSuchMethodFitFailureException(name);
        }
        return TypeAdapter.on((Fixture)fixture, (Method)method, (boolean)true);
    }

    private static Method getMethod(String name, Fixture fixture, Matcher matcher) {
        Method method = null;
        if (GracefulNamer.isGracefulName((String)name)) {
            String simpleName = GracefulNamer.disgrace((String)name).toLowerCase();
            method = Binding.findMethod((Fixture)fixture, (String)simpleName);
        } else {
            try {
                String methodName = matcher.group(1);
                method = fixture.getTargetClass().getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return method;
    }

    private static Field findField(Fixture fixture, String simpleName) {
        Field[] fields = Binding.getAllDeclaredFields((Class)fixture.getTargetClass());
        Field field = null;
        for (int i = 0; i < fields.length; ++i) {
            Field possibleField = fields[i];
            if (!simpleName.equals(possibleField.getName().toLowerCase())) continue;
            field = possibleField;
            break;
        }
        return field;
    }

    private static Field[] getAllDeclaredFields(Class<?> clazz) {
        if (clazz.getSuperclass() != null) {
            return (Field[])ArrayUtils.addAll((Object[])Binding.getAllDeclaredFields(clazz.getSuperclass()), (Object[])clazz.getDeclaredFields());
        }
        return clazz.getDeclaredFields();
    }

    private static Method findMethod(Fixture fixture, String simpleName) {
        Method[] methods = fixture.getTargetClass().getMethods();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            Method possibleMethod = methods[i];
            if (!simpleName.equals(possibleMethod.getName().toLowerCase())) continue;
            method = possibleMethod;
            break;
        }
        return method;
    }

    public abstract void doCell(Fixture var1, Parse var2) throws Throwable;
}

