/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import fit.FixtureTest;
import fit.Parse;
import fit.ScientificDouble;
import fit.TypeAdapter;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class FixtureTest
extends RegexTestCase {
    private Locale saveLocale;

    protected void setUp() throws Exception {
        super.setUp();
        this.saveLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Locale.setDefault(this.saveLocale);
    }

    public void testHasParseMethod() throws Exception {
        FixtureTest.assertTrue((boolean)Fixture.hasParseMethod(HasParseMethod.class));
        FixtureTest.assertFalse((boolean)Fixture.hasParseMethod(HasNoParseMethod.class));
    }

    public void testCallParseMethod() throws Exception {
        Object o = Fixture.callParseMethod(HasParseMethod.class, (String)"target");
        FixtureTest.assertTrue((boolean)(o instanceof String));
        String s = (String)o;
        FixtureTest.assertEquals((String)"target found", (String)s);
    }

    public void testObjectWithParseMethod() throws Exception {
        Fixture f = new Fixture();
        Object o = f.parse("target", HasParseMethod.class);
        FixtureTest.assertTrue((boolean)(o instanceof String));
        FixtureTest.assertEquals((String)"target found", (String)((String)o));
        try {
            f.parse("target", HasNoParseMethod.class);
            FixtureTest.fail();
        }
        catch (Exception e) {
            FixtureTest.assertTrue((boolean)e.getMessage().startsWith("Could not parse"));
        }
    }

    public void testScientificDouble() throws Exception {
        Fixture f = new Fixture();
        Object o = f.parse("13.4", ScientificDouble.class);
        FixtureTest.assertTrue((boolean)(o instanceof ScientificDouble));
        FixtureTest.assertEquals((Object)new ScientificDouble(13.4), (Object)o);
    }

    public void testRelationalMatching() throws Exception {
        String[][] table = new String[][]{{"fitnesse.fixtures.ColumnFixtureTestFixture"}, {"input", "output?"}, {"1", "_>0"}};
        Parse page = FixtureTest.executeFixture((String[][])table);
        String colTwoResult = page.at((int)0, (int)2, (int)1).body;
        FixtureTest.assertTrue((boolean)colTwoResult.contains("<b>1</b>>0"));
        String colTwoTag = page.at((int)0, (int)2, (int)1).tag;
        FixtureTest.assertTrue((boolean)colTwoTag.contains("pass"));
    }

    public void testNullAndBlankStrings() throws Exception {
        Fixture fixture = new Fixture();
        FixtureTest.assertNull((Object)fixture.parse("null", String.class));
        FixtureTest.assertEquals((Object)"", (Object)fixture.parse("blank", String.class));
        TypeAdapter adapter = new TypeAdapter();
        FixtureTest.assertEquals((String)"null", (String)adapter.toString((Object)null));
        FixtureTest.assertEquals((String)"blank", (String)adapter.toString((Object)""));
    }

    public void testEscape() {
        String junk = "!@#$%^*()_-+={}|[]\\:\";',./?`";
        FixtureTest.assertEquals((String)junk, (String)Fixture.escape((String)junk));
        FixtureTest.assertEquals((String)"", (String)Fixture.escape((String)""));
        FixtureTest.assertEquals((String)"&lt;", (String)Fixture.escape((String)"<"));
        FixtureTest.assertEquals((String)"&lt;&lt;", (String)Fixture.escape((String)"<<"));
        FixtureTest.assertEquals((String)"x&lt;", (String)Fixture.escape((String)"x<"));
        FixtureTest.assertEquals((String)"&amp;", (String)Fixture.escape((String)"&"));
        FixtureTest.assertEquals((String)"&lt;&amp;&lt;", (String)Fixture.escape((String)"<&<"));
        FixtureTest.assertEquals((String)"&amp;&lt;&amp;", (String)Fixture.escape((String)"&<&"));
        FixtureTest.assertEquals((String)"a &lt; b &amp;&amp; c &lt; d", (String)Fixture.escape((String)"a < b && c < d"));
    }

    public void testFixtureArguments() throws Exception {
        String prefix = "<table><tr><td>fit.Fixture</td>";
        String suffix = "</tr></table>";
        Fixture f = new Fixture();
        Parse table = new Parse(prefix + "<td>1</td>" + suffix);
        f.getArgsForTable(table);
        String[] args = f.getArgs();
        FixtureTest.assertEquals((int)1, (int)args.length);
        FixtureTest.assertEquals((String)"1", (String)args[0]);
        table = new Parse(prefix + "" + suffix);
        f.getArgsForTable(table);
        args = f.getArgs();
        FixtureTest.assertEquals((int)0, (int)args.length);
        table = new Parse(prefix + "<td>1</td><td>2</td>" + suffix);
        f.getArgsForTable(table);
        args = f.getArgs();
        FixtureTest.assertEquals((int)2, (int)args.length);
        FixtureTest.assertEquals((String)"1", (String)args[0]);
        FixtureTest.assertEquals((String)"2", (String)args[1]);
    }

    public void testParseDate() throws Exception {
        Fixture f = new Fixture();
        Object o = f.parse("1/2/2004", Date.class);
        FixtureTest.assertEquals(Date.class, o.getClass());
    }

    public static Parse executeFixture(String[][] table) throws ParseException {
        String pageString = FixtureTest.makeFixtureTable((String[][])table);
        Parse page = new Parse(pageString);
        Fixture fixture = new Fixture();
        fixture.doTables(page);
        return page;
    }

    public void testCanChangeFriendlyExceptions() throws Exception {
        1 fixture = new /* Unavailable Anonymous Inner Class!! */;
        Parse cell = new Parse("td", "", null, null);
        fixture.exception(cell, (Throwable)new NullPointerException("gobble gobble"));
        FixtureTest.assertSubString((String)"gobble gobble", (String)cell.body);
        FixtureTest.assertNotSubString((String)"Exception", (String)cell.body);
    }

    public void testClearingSymbols() throws Exception {
        Fixture.setSymbol((String)"blah", (Object)"blah");
        FixtureTest.assertEquals((Object)"blah", (Object)Fixture.getSymbol((String)"blah"));
        Fixture.ClearSymbols();
        FixtureTest.assertEquals(null, (Object)Fixture.getSymbol((String)"blah"));
    }

    private static String makeFixtureTable(String[][] table) {
        StringBuffer buf = new StringBuffer();
        buf.append("<table>\n");
        for (int ri = 0; ri < table.length; ++ri) {
            buf.append("  <tr>");
            String[] row = table[ri];
            for (int ci = 0; ci < row.length; ++ci) {
                String cell = row[ci];
                buf.append("<td>").append(cell).append("</td>");
            }
            buf.append("</tr>\n");
        }
        buf.append("</table>\n");
        return buf.toString();
    }
}

