/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator;

import fit.Counts;
import fit.Parse;
import fit.decorator.FixtureDecorator;
import fit.decorator.FixtureDecoratorTestCase;
import fit.decorator.IncrementColumnsValue;
import fit.decorator.exceptions.InvalidInputException;
import fit.decorator.util.Delta;
import fit.decorator.util.TestCaseHelper;
import java.text.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class IncrementColumnsValueTest
extends FixtureDecoratorTestCase {
    private static final String FIRST_HTML_ROW = "<tr><td>" + IncrementColumnsValue.class.getName() + "</td><td>ColumnName</td><td>of type</td><td>int</td><td>by</td><td>1</td></tr>";
    private FixtureDecorator decorator = new IncrementColumnsValue();

    protected String geDecoratorHTMLRow() {
        return FIRST_HTML_ROW;
    }

    protected int numberOfAssertionsOnDecorator() {
        return 0;
    }

    public void testSetupDecoratorShouldAddColumnNameDataTypeAndDeltaToSummary() throws Exception {
        this.decorator.setupDecorator(new String[]{"Column1", "int", "1"});
        IncrementColumnsValueTest.assertEquals((String)"Column1", (String)((String)this.decorator.summary.get("columnName")));
        IncrementColumnsValueTest.assertEquals((Object)new Delta("int", "1"), this.decorator.summary.get("delta"));
    }

    public void testSetupDecoratorShouldAddColumnNameDataTypeAndDeltaToSummaryForDates() throws Exception {
        this.decorator.setupDecorator(new String[]{"Column1", "date", "5"});
        IncrementColumnsValueTest.assertEquals((String)"Column1", (String)((String)this.decorator.summary.get("columnName")));
        IncrementColumnsValueTest.assertEquals((Object)new Delta("date", "5"), this.decorator.summary.get("delta"));
    }

    public void testSetupDecoratorShouldThrowInvalidInputExceptionIfColumnNameIsNotSpecified() throws ParseException {
        this.assertInvalidInputException(new String[0], "Column name, Data type and Delta Value must be specified");
    }

    public void testSetupDecoratorShouldThrowInvalidInputExceptionIfDataTypeIsNotSpecified() throws ParseException {
        this.assertInvalidInputException(new String[]{"Column1"}, "Column name, Data type and Delta Value must be specified");
    }

    public void testSetupDecoratorShouldThrowInvalidInputExceptionIfDeltaValueIsNotSpecified() throws ParseException {
        this.assertInvalidInputException(new String[]{"Column1", "double"}, "Column name, Data type and Delta Value must be specified");
    }

    public void testSetupDecoratorShouldThrowInvalidInputExceptionIfDataTypeAndDeltaValueDoNotMatch() throws ParseException {
        this.assertInvalidInputException(new String[]{"Column1", "double", "xyz"}, "value 'xyz' is not a valid DataType = 'double'");
        this.assertInvalidInputException(new String[]{"Column1", "int", "1.2"}, "value '1.2' is not a valid DataType = 'int'");
        this.assertInvalidInputException(new String[]{"Column1", "date", "12-5-2006"}, "value '12-5-2006' is not a valid DataType = 'date'");
    }

    public void testSetupDecoratorShouldDefaultDataTypeToStringIfItDoesNotMatch_int_integer_double_or_date() throws Exception {
        this.decorator.setupDecorator(new String[]{"Column1", "long", "1"});
        IncrementColumnsValueTest.assertEquals((Object)new Delta("String", "1"), this.decorator.summary.get("delta"));
    }

    public void testSetupDecoratorShouldDefaultDataTypeTo_int() throws Exception {
        this.decorator.setupDecorator(new String[]{"Column1", "integer", "1"});
        IncrementColumnsValueTest.assertEquals((Object)new Delta("INT", "1"), this.decorator.summary.get("delta"));
    }

    public void testShouldIncrementColumnValuesFromSecondRowForTheGivenColumnName() throws Exception {
        String fitPage = "<table><tr><td>" + IncrementColumnsValue.class.getName() + "</td><td>numerator</td><td>of type</td><td>int</td><td>by</td><td>5</td></tr>" + "<tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr><tr><td>10</td><td>3</td><td>5</td></tr>" + "<tr><td>10</td><td>3</td><td>5</td></tr></table>";
        this.decorator.doTable(new Parse(fitPage));
        TestCaseHelper.assertCounts((Counts)TestCaseHelper.counts((int)2, (int)1, (int)0, (int)0), (Counts)this.decorator.counts);
    }

    public void testShouldIncrementDateColumnValuesFromSecondRowForTheGivenColumnName() throws Exception {
        String fitPage = "<table><tr><td>" + IncrementColumnsValue.class.getName() + "</td><td>inDate</td><td>of type</td><td>date</td><td>by</td><td>5</td></tr>" + "<tr><td>eg.GetDates</td></tr><tr><td>inDate</td><td>updatedDate()</td></tr>" + "<tr><td>12/02/2006</td><td>12/02/2006</td></tr>" + "<tr><td>12/02/2006</td><td>12/07/2006</td></tr>" + "<tr><td>12/22/2006</td><td>01/01/2007</td></tr></table>";
        this.decorator.doTable(new Parse(fitPage));
        TestCaseHelper.assertCounts((Counts)TestCaseHelper.counts((int)3, (int)0, (int)0, (int)0), (Counts)this.decorator.counts);
    }

    public void testShouldLeaveTheTableAsItIsIfTablesHasLessThanFourRows() throws Exception {
        String fitPage = "<table><tr><td>" + IncrementColumnsValue.class.getName() + "</td><td>numerator</td><td>of type</td><td>int</td><td>by</td><td>5</td></tr>" + "<tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr></table>";
        this.decorator.doTable(new Parse(fitPage));
        TestCaseHelper.assertCounts((Counts)TestCaseHelper.counts((int)1, (int)0, (int)0, (int)0), (Counts)this.decorator.counts);
    }

    public void testShouldHandleExceptionsByIgnoringDecorator() throws Exception {
        String fitPage = "<table><tr><td>" + IncrementColumnsValue.class.getName() + "</td><td>invalidColumnName</td><td>of type</td><td>int</td><td>by</td><td>5</td></tr>" + "<tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr></table>";
        this.decorator.doTable(new Parse(fitPage));
        TestCaseHelper.assertCounts((Counts)TestCaseHelper.counts((int)1, (int)0, (int)0, (int)0), (Counts)this.decorator.counts);
    }

    public void testShouldIncrementMultipleColumnsValueIfDecoratorIsPiped() throws Exception {
        String fitPage = "<table><tr><td>" + IncrementColumnsValue.class.getName() + "</td><td>numerator</td><td>of type</td><td>int</td><td>by</td><td>5</td></tr>" + "<tr><td>" + IncrementColumnsValue.class.getName() + "</td><td>denominator</td><td>of type</td><td>int</td><td>by</td><td>1</td></tr>" + "<tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr></table>";
        this.decorator.doTable(new Parse(fitPage));
        TestCaseHelper.assertCounts((Counts)TestCaseHelper.counts((int)2, (int)0, (int)0, (int)0), (Counts)this.decorator.counts);
    }

    private void assertInvalidInputException(String[] args, String errorMsg) throws ParseException {
        try {
            this.decorator.setupDecorator(args);
            IncrementColumnsValueTest.fail((String)"Should blow up");
        }
        catch (InvalidInputException e) {
            IncrementColumnsValueTest.assertEquals((String)errorMsg, (String)e.getMessage());
        }
    }
}

