/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator.util;

import fit.Parse;
import fit.decorator.exceptions.InvalidInputException;
import fit.decorator.util.Delta;
import fit.decorator.util.Table;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class TableTest
extends TestCase {
    private String fitPage = "<table><tr><td>eg.Division</td></tr><tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr><tr><td>10</td><td>2</td><td>5</td></tr></table>";
    private Table table;

    protected void setUp() throws Exception {
        super.setUp();
        this.table = new Table(this.fitPage);
    }

    public void testToStringShouldParseTableWithMultipleRowsAndColumns() throws Exception {
        this.assertTable(this.fitPage);
    }

    public void testConstructorShouldBuildTableFromParseObject() throws Exception {
        String expectedTableContents = "<tr><td>fit.decorator.MaxTime</td><td>10</td></tr>";
        Parse parse = new Parse(expectedTableContents, new String[]{"tr", "td"});
        this.table = new Table(parse);
        this.assertTable(expectedTableContents);
    }

    public void testCopyAndAppendLastRow() throws Exception {
        this.table.copyAndAppendLastRow(1);
        String expectedTableContents = "<table><tr><td>eg.Division</td></tr><tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr><tr><td>10</td><td>2</td><td>5</td></tr><tr><td>10</td><td>2</td><td>5</td></tr></table>";
        this.assertTable(expectedTableContents);
    }

    public void testCopyAndAppendLastRowMultipleTimes() throws Exception {
        this.table.copyAndAppendLastRow(3);
        String expectedTableContents = "<table><tr><td>eg.Division</td></tr><tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr><tr><td>10</td><td>2</td><td>5</td></tr><tr><td>10</td><td>2</td><td>5</td></tr><tr><td>10</td><td>2</td><td>5</td></tr><tr><td>10</td><td>2</td><td>5</td></tr></table>";
        this.assertTable(expectedTableContents);
    }

    public void testCopyAndAppendLastRowZeroTime() throws Exception {
        this.table.copyAndAppendLastRow(0);
        this.assertTable(this.fitPage);
    }

    public void testIncrementColumnValueThrowsInvalidInputExceptionIfColumnNameIsNotFound() throws Exception {
        try {
            this.table.incrementColumnValues(1, "invalidColumnName", null);
        }
        catch (InvalidInputException e) {
            TableTest.assertEquals((String)("'invalidColumnName' was not found in the table " + this.fitPage), (String)e.getMessage());
        }
    }

    public void testIncrementColumnValueShouldAddTheGivenDeltaToAllRowsOfTheGivenColumn() throws Exception {
        this.table.incrementColumnValues("denominator", new Delta("int", "1"), 1);
        this.assertTable(this.fitPage);
    }

    public void testIncrementColumnValueShouldIncrementallyAddTheGivenDeltaMultipleTimes() throws Exception {
        this.table.incrementColumnValues(3, "denominator", new Delta("int", "1"));
        String expectedFitPage = "<table><tr><td>eg.Division</td></tr><tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr><tr><td>10</td><td>2</td><td>5</td></tr><tr><td>10</td><td>3</td><td>5</td></tr><tr><td>10</td><td>4</td><td>5</td></tr></table>";
        this.assertTable(expectedFitPage);
    }

    public void testInsertAsFirstRow() throws Exception {
        Parse firstRow = new Parse("<tr><td>first row</td></tr>", new String[]{"tr", "td"});
        this.table.insertAsFirstRow(firstRow);
        String expectedTableContents = "<table><tr><td>first row</td></tr><tr><td>eg.Division</td></tr><tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr><tr><td>10</td><td>2</td><td>5</td></tr></table>";
        this.assertTable(expectedTableContents);
    }

    public void testStripFirstRow() throws Exception {
        this.table.stripFirstRow();
        String expectedTableContents = "<table><tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr><tr><td>10</td><td>2</td><td>5</td></tr></table>";
        this.assertTable(expectedTableContents);
    }

    public void testColumnNumberShouldReturnColumnNumberForTheGivenColumnName() throws Exception {
        TableTest.assertEquals((int)0, (int)this.table.columnNumberContainingText("numerator", 1));
        TableTest.assertEquals((int)1, (int)this.table.columnNumberContainingText("denominator", 1));
        TableTest.assertEquals((int)2, (int)this.table.columnNumberContainingText("quotient()", 1));
    }

    public void testColumnNumberShouldThrowsInvalidInputExceptionIfColumnNameIsNotFound() throws Exception {
        try {
            this.table.columnNumberContainingText("invalidColumnName", 1);
        }
        catch (InvalidInputException e) {
            TableTest.assertEquals((String)("'invalidColumnName' was not found in the table " + this.fitPage), (String)e.getMessage());
        }
    }

    public void testColumnValueShouldReturnColumnValueForTheGivenColumnNumber() throws Exception {
        TableTest.assertEquals((String)"10", (String)this.table.columnValue(2, 0));
        TableTest.assertEquals((String)"2", (String)this.table.columnValue(2, 1));
        TableTest.assertEquals((String)"5", (String)this.table.columnValue(2, 2));
    }

    public void testGetLastRow() throws Exception {
        Parse lastRow = this.table.lastRow();
        String expectedLastRow = "<tr><td>10</td><td>2</td><td>5</td></tr>";
        this.assertParseObject(expectedLastRow, lastRow);
    }

    public void testGetSecondLastRow() throws Exception {
        String fitPage = "<table><tr><td>eg.Division</td></tr><tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr><tr><td>10</td><td>2</td><td>5</td></tr><tr><td>5</td><td>1</td><td>5</td></tr></table>";
        this.table = new Table(fitPage);
        Parse secondLastRow = this.table.secondLastRow(this.table.lastRow());
        String expectedSecondLastRow = "<tr><td>10</td><td>2</td><td>5</td></tr>";
        this.assertParseObject(expectedSecondLastRow, secondLastRow);
    }

    public void testRowNumberContainingTextShouldReturnIndexOfTheRowContainingTheText() throws Exception {
        TableTest.assertEquals((int)0, (int)this.table.rowNumberContainingText("eg.Division"));
        TableTest.assertEquals((int)1, (int)this.table.rowNumberContainingText("numerator"));
        TableTest.assertEquals((int)1, (int)this.table.rowNumberContainingText("denominator"));
    }

    public void testRowNumberContainingTextShouldThrowInvalidInputExceptionIfSearchTextIsNotFound() throws Exception {
        try {
            this.table.rowNumberContainingText("invalidColumnName");
        }
        catch (InvalidInputException e) {
            TableTest.assertEquals((String)("'invalidColumnName' was not found in the table " + this.fitPage), (String)e.getMessage());
        }
    }

    public void testCopyAndAppendLastRowShouldLeaveTheTableAsItIsIfTotalRowsAreLessThanThree() throws Exception {
        String fitPage = "<table><tr><td>eg.Division</td></tr><tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr></table>";
        this.table = new Table(fitPage);
        this.table.copyAndAppendLastRow(4);
        this.assertTable(fitPage);
    }

    private void assertTable(String expectedTableContents) {
        TableTest.assertEquals((String)expectedTableContents, (String)this.table.toString());
    }

    private void assertParseObject(String expectedTableContents, Parse parse) {
        TableTest.assertEquals((String)expectedTableContents, (String)new Table(parse).toString());
    }
}

