/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.ComponentFactory;
import fitnesse.ComponentFactoryTest;
import fitnesse.WikiPageFactory;
import fitnesse.authentication.Authenticator;
import fitnesse.authentication.PromiscuousAuthenticator;
import fitnesse.responders.ResponderFactory;
import fitnesse.responders.WikiPageResponder;
import fitnesse.responders.editing.EditResponder;
import fitnesse.responders.editing.SaveResponder;
import fitnesse.testsystems.slim.HtmlTable;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import fitnesse.testutil.SimpleAuthenticator;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.NullVersionsController;
import fitnesse.wiki.VersionsController;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.zip.ZipFileVersionsController;
import fitnesse.wikitext.parser.ParseSpecification;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.SymbolMatch;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolStream;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Today;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import org.htmlparser.Node;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.tags.TableColumn;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class ComponentFactoryTest
extends RegexTestCase {
    private Properties testProperties;
    private ComponentFactory factory;
    private SymbolProvider testProvider;

    public void setUp() throws Exception {
        this.testProperties = new Properties();
        this.testProvider = new SymbolProvider(new SymbolType[0]);
        this.factory = new ComponentFactory(this.testProperties, this.testProvider);
    }

    public void tearDown() throws Exception {
        File file = new File("plugins.properties");
        FileOutputStream out = new FileOutputStream(file);
        out.write("".getBytes());
        out.close();
    }

    public void testRootPageCreation() throws Exception {
        this.testProperties.setProperty("WikiPage", InMemoryPage.class.getName());
        WikiPageFactory wikiPageFactory = new WikiPageFactory();
        this.factory.loadWikiPage(wikiPageFactory);
        ComponentFactoryTest.assertEquals(InMemoryPage.class, (Object)wikiPageFactory.getWikiPageClass());
        WikiPage page = wikiPageFactory.makeRootPage(null, "", this.factory);
        ComponentFactoryTest.assertNotNull((Object)page);
        ComponentFactoryTest.assertEquals(InMemoryPage.class, page.getClass());
    }

    public void testDefaultRootPage() throws Exception {
        WikiPageFactory wikiPageFactory = new WikiPageFactory();
        this.factory.loadWikiPage(wikiPageFactory);
        ComponentFactoryTest.assertEquals(FileSystemPage.class, (Object)wikiPageFactory.getWikiPageClass());
        WikiPage page = wikiPageFactory.makeRootPage("testPath", "TestRoot", this.factory);
        ComponentFactoryTest.assertNotNull((Object)page);
        ComponentFactoryTest.assertEquals(FileSystemPage.class, page.getClass());
        ComponentFactoryTest.assertEquals((String)"TestRoot", (String)page.getName());
    }

    public void testAddPlugins() throws Exception {
        this.testProperties.setProperty("Plugins", DummyPlugin.class.getName());
        WikiPageFactory wikiPageFactory = new WikiPageFactory();
        ResponderFactory responderFactory = new ResponderFactory(".");
        this.assertMatch("!today", false);
        String output = this.factory.loadPlugins(responderFactory, wikiPageFactory);
        ComponentFactoryTest.assertSubString((String)DummyPlugin.class.getName(), (String)output);
        ComponentFactoryTest.assertEquals(InMemoryPage.class, (Object)wikiPageFactory.getWikiPageClass());
        ComponentFactoryTest.assertEquals(WikiPageResponder.class, (Object)responderFactory.getResponderClass("custom1"));
        ComponentFactoryTest.assertEquals(EditResponder.class, (Object)responderFactory.getResponderClass("custom2"));
        this.assertMatch("!today", true);
    }

    private void assertMatch(String input, boolean expected) {
        SymbolMatch match = new ParseSpecification().provider(this.testProvider).findMatch(new ScanString(input, 0), 0, new SymbolStream());
        ComponentFactoryTest.assertEquals((boolean)match.isMatch(), (boolean)expected);
    }

    public void testAddResponderPlugins() throws Exception {
        String respondersValue = "custom1:" + WikiPageResponder.class.getName() + ",custom2:" + EditResponder.class.getName();
        this.testProperties.setProperty("Responders", respondersValue);
        ResponderFactory responderFactory = new ResponderFactory(".");
        String output = this.factory.loadResponders(responderFactory);
        ComponentFactoryTest.assertSubString((String)("custom1:" + WikiPageResponder.class.getName()), (String)output);
        ComponentFactoryTest.assertSubString((String)("custom2:" + EditResponder.class.getName()), (String)output);
        ComponentFactoryTest.assertEquals(WikiPageResponder.class, (Object)responderFactory.getResponderClass("custom1"));
        ComponentFactoryTest.assertEquals(EditResponder.class, (Object)responderFactory.getResponderClass("custom2"));
    }

    public void testWikiWidgetPlugins() throws Exception {
        String symbolValues = Today.class.getName();
        this.testProperties.setProperty("SymbolTypes", symbolValues);
        String output = this.factory.loadSymbolTypes();
        ComponentFactoryTest.assertSubString((String)Today.class.getName(), (String)output);
        this.assertMatch("!today", true);
    }

    public void testAuthenticatorDefaultCreation() throws Exception {
        Authenticator authenticator = this.factory.getAuthenticator((Authenticator)new PromiscuousAuthenticator());
        ComponentFactoryTest.assertNotNull((Object)authenticator);
        ComponentFactoryTest.assertEquals(PromiscuousAuthenticator.class, authenticator.getClass());
    }

    public void testAuthenticatorCustomCreation() throws Exception {
        this.testProperties.setProperty("Authenticator", SimpleAuthenticator.class.getName());
        Authenticator authenticator = this.factory.getAuthenticator((Authenticator)new PromiscuousAuthenticator());
        ComponentFactoryTest.assertNotNull((Object)authenticator);
        ComponentFactoryTest.assertEquals(SimpleAuthenticator.class, authenticator.getClass());
    }

    public void testContentFilterCreation() throws Exception {
        ComponentFactoryTest.assertEquals((String)"", (String)this.factory.loadContentFilter());
        ComponentFactoryTest.assertEquals(null, (Object)SaveResponder.contentFilter);
        this.testProperties.setProperty("ContentFilter", TestContentFilter.class.getName());
        String content = this.factory.loadContentFilter();
        ComponentFactoryTest.assertEquals((String)("\tContent filter installed: " + SaveResponder.contentFilter.getClass().getName() + "\n"), (String)content);
        ComponentFactoryTest.assertNotNull((Object)SaveResponder.contentFilter);
        ComponentFactoryTest.assertEquals(TestContentFilter.class, SaveResponder.contentFilter.getClass());
    }

    public void testSlimTablesCreation() throws ClassNotFoundException {
        this.testProperties.setProperty("SlimTables", "test:" + TestSlimTable.class.getName());
        String content = this.factory.loadSlimTables();
        ComponentFactoryTest.assertTrue((boolean)content.contains("test:"));
        ComponentFactoryTest.assertTrue((boolean)content.contains("TestSlimTable"));
        HtmlTable table = this.makeMockTable("test");
        SlimTable slimTable = new SlimTableFactory().makeSlimTable((Table)table, "foo", (SlimTestContext)new SlimTestContextImpl());
        ComponentFactoryTest.assertSame(TestSlimTable.class, slimTable.getClass());
    }

    public void testSlimTablesWithColonCreation() throws ClassNotFoundException {
        this.testProperties.setProperty("SlimTables", "test::" + TestSlimTable.class.getName());
        String content = this.factory.loadSlimTables();
        ComponentFactoryTest.assertTrue((boolean)content.contains("test:"));
        ComponentFactoryTest.assertTrue((boolean)content.contains("TestSlimTable"));
        HtmlTable table = this.makeMockTable("test:");
        SlimTable slimTable = new SlimTableFactory().makeSlimTable((Table)table, "foo", (SlimTestContext)new SlimTestContextImpl());
        ComponentFactoryTest.assertSame(TestSlimTable.class, slimTable.getClass());
    }

    private HtmlTable makeMockTable(String tableIdentifier) {
        TableTag tableTag = new TableTag();
        TableRow tableRow = new TableRow();
        TableColumn tableColumn = new TableColumn();
        tableColumn.setChildren(new NodeList((Node)new TextNode(tableIdentifier)));
        tableRow.setChildren(new NodeList((Node)tableColumn));
        tableTag.setChildren(new NodeList((Node)tableRow));
        return new HtmlTable(tableTag);
    }

    public void testShouldUseZipFileRevisionControllerAsDefault() throws Exception {
        VersionsController defaultRevisionController = this.factory.loadVersionsController();
        ComponentFactoryTest.assertEquals(ZipFileVersionsController.class, defaultRevisionController.getClass());
    }

    public void testShouldUseSpecifiedRevisionController() throws Exception {
        this.testProperties.setProperty("VersionsController", NullVersionsController.class.getName());
        VersionsController defaultRevisionController = this.factory.loadVersionsController();
        ComponentFactoryTest.assertEquals(NullVersionsController.class, defaultRevisionController.getClass());
    }
}

