/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.RecentChanges;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import java.util.List;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class RecentChangesTest
extends RegexTestCase {
    private WikiPage rootPage;
    private WikiPage newPage;
    private WikiPage page1;
    private WikiPage page2;

    public void setUp() throws Exception {
        this.rootPage = InMemoryPage.makeRoot((String)"RooT");
        this.newPage = this.rootPage.addChildPage("SomeNewPage");
        this.page1 = this.rootPage.addChildPage("PageOne");
        this.page2 = this.rootPage.addChildPage("PageTwo");
    }

    public void tearDown() throws Exception {
    }

    public void testFirstRecentChange() throws Exception {
        RecentChangesTest.assertEquals((boolean)false, (boolean)this.rootPage.hasChildPage("RecentChanges"));
        RecentChanges.updateRecentChanges((PageData)this.newPage.getData());
        RecentChangesTest.assertEquals((boolean)true, (boolean)this.rootPage.hasChildPage("RecentChanges"));
        WikiPage recentChanges = this.rootPage.getChildPage("RecentChanges");
        List lines = RecentChanges.getRecentChangesLines((PageData)recentChanges.getData());
        RecentChangesTest.assertEquals((int)1, (int)lines.size());
        RecentChangesTest.assertHasRegexp((String)"SomeNewPage", (String)((String)lines.get(0)));
    }

    public void testTwoChanges() throws Exception {
        RecentChanges.updateRecentChanges((PageData)this.page1.getData());
        RecentChanges.updateRecentChanges((PageData)this.page2.getData());
        WikiPage recentChanges = this.rootPage.getChildPage("RecentChanges");
        List lines = RecentChanges.getRecentChangesLines((PageData)recentChanges.getData());
        RecentChangesTest.assertEquals((int)2, (int)lines.size());
        RecentChangesTest.assertHasRegexp((String)"PageTwo", (String)((String)lines.get(0)));
        RecentChangesTest.assertHasRegexp((String)"PageOne", (String)((String)lines.get(1)));
    }

    public void testNoDuplicates() throws Exception {
        RecentChanges.updateRecentChanges((PageData)this.page1.getData());
        RecentChanges.updateRecentChanges((PageData)this.page1.getData());
        WikiPage recentChanges = this.rootPage.getChildPage("RecentChanges");
        List lines = RecentChanges.getRecentChangesLines((PageData)recentChanges.getData());
        RecentChangesTest.assertEquals((int)1, (int)lines.size());
        RecentChangesTest.assertHasRegexp((String)"PageOne", (String)((String)lines.get(0)));
    }

    public void testMaxSize() throws Exception {
        for (int i = 0; i < 101; ++i) {
            StringBuffer b = new StringBuffer("LotsOfAs");
            for (int j = 0; j < i; ++j) {
                b.append("a");
            }
            WikiPage page = this.rootPage.addChildPage(b.toString());
            RecentChanges.updateRecentChanges((PageData)page.getData());
        }
        WikiPage recentChanges = this.rootPage.getChildPage("RecentChanges");
        List lines = RecentChanges.getRecentChangesLines((PageData)recentChanges.getData());
        RecentChangesTest.assertEquals((int)100, (int)lines.size());
    }

    public void testUsernameColumnWithoutUser() throws Exception {
        RecentChanges.updateRecentChanges((PageData)this.page1.getData());
        WikiPage recentChanges = this.rootPage.getChildPage("RecentChanges");
        List lines = RecentChanges.getRecentChangesLines((PageData)recentChanges.getData());
        String line = ((String)lines.get(0)).toString();
        RecentChangesTest.assertSubString((String)"|PageOne||", (String)line);
    }

    public void testUsernameColumnWithUser() throws Exception {
        PageData data = this.page1.getData();
        data.setAttribute("LastModifyingUser", "Aladdin");
        this.page1.commit(data);
        RecentChanges.updateRecentChanges((PageData)this.page1.getData());
        WikiPage recentChanges = this.rootPage.getChildPage("RecentChanges");
        List lines = RecentChanges.getRecentChangesLines((PageData)recentChanges.getData());
        String line = ((String)lines.get(0)).toString();
        RecentChangesTest.assertSubString((String)"|PageOne|Aladdin|", (String)line);
    }
}

