/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.SaveRecorder;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SaveRecorderTest {
    public WikiPage somePage;
    public WikiPage root;
    private PageCrawler crawler;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.somePage = this.crawler.addPage(this.root, PathParser.parse((String)"SomePage"), "some page");
    }

    @Test
    public void testTiming() throws Exception {
        PageData data = this.somePage.getData();
        long savedTicket = 0L;
        long editTicket = 1L;
        long time = SaveRecorder.pageSaved((PageData)data, (long)savedTicket);
        this.somePage.commit(data);
        Assert.assertTrue((boolean)SaveRecorder.changesShouldBeMerged((long)(time - 1L), (long)editTicket, (PageData)this.somePage.getData()));
        Assert.assertFalse((boolean)SaveRecorder.changesShouldBeMerged((long)(time + 1L), (long)editTicket, (PageData)this.somePage.getData()));
    }

    @Test
    public void testDefaultValues() throws Exception {
        WikiPage neverSaved = this.crawler.addPage(this.root, PathParser.parse((String)"NeverSaved"), "never saved");
        Assert.assertFalse((boolean)SaveRecorder.changesShouldBeMerged((long)12345L, (long)0L, (PageData)neverSaved.getData()));
    }

    @Test
    public void testCanSaveOutOfOrderIfFromSameEditSession() throws Exception {
        PageData data = this.somePage.getData();
        long ticket = 99L;
        long time = SaveRecorder.pageSaved((PageData)data, (long)ticket);
        this.somePage.commit(data);
        Assert.assertFalse((boolean)SaveRecorder.changesShouldBeMerged((long)(time - 1L), (long)ticket, (PageData)data));
    }
}

