/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.SocketDealer;
import fitnesse.components.SocketDealerTest;
import fitnesse.testsystems.fit.SimpleSocketSeeker;
import fitnesse.testsystems.fit.SocketDoner;
import fitnesse.testsystems.fit.SocketSeeker;
import java.util.Collection;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class SocketDealerTest
extends TestCase {
    private SocketDealer dealer;
    private SimpleSocketSeeker seeker;
    private int ticket;
    private SimpleDoner doner;

    public void setUp() throws Exception {
        this.dealer = new SocketDealer();
    }

    public void tearDown() throws Exception {
    }

    public void testAddSeeker() throws Exception {
        SimpleSocketSeeker seeker = new SimpleSocketSeeker();
        this.dealer.seekingSocket((SocketSeeker)seeker);
        Collection waiting = this.dealer.getWaitingList();
        SocketDealerTest.assertEquals((int)1, (int)waiting.size());
        SocketDealerTest.assertTrue((boolean)waiting.contains(seeker));
    }

    public void testUniqueTicketNumber() throws Exception {
        int ticketNumber2;
        int ticketNumber1 = this.dealer.seekingSocket((SocketSeeker)new SimpleSocketSeeker());
        SocketDealerTest.assertTrue((ticketNumber1 != (ticketNumber2 = this.dealer.seekingSocket((SocketSeeker)new SimpleSocketSeeker())) ? 1 : 0) != 0);
    }

    public void testDealSocketTo() throws Exception {
        this.doSimpleDealing();
        SocketDealerTest.assertSame((Object)this.doner.socket, (Object)this.seeker.socket);
    }

    private void doSimpleDealing() throws Exception {
        this.seeker = new SimpleSocketSeeker();
        this.ticket = this.dealer.seekingSocket((SocketSeeker)this.seeker);
        this.doner = new SimpleDoner();
        this.dealer.dealSocketTo(this.ticket, (SocketDoner)this.doner);
    }

    public void testDealSocketToMultipleSeekers() throws Exception {
        SimpleSocketSeeker seeker1 = new SimpleSocketSeeker();
        SimpleSocketSeeker seeker2 = new SimpleSocketSeeker();
        int ticket1 = this.dealer.seekingSocket((SocketSeeker)seeker1);
        int ticket2 = this.dealer.seekingSocket((SocketSeeker)seeker2);
        SimpleDoner doner1 = new SimpleDoner();
        SimpleDoner doner2 = new SimpleDoner();
        this.dealer.dealSocketTo(ticket1, (SocketDoner)doner1);
        this.dealer.dealSocketTo(ticket2, (SocketDoner)doner2);
        SocketDealerTest.assertSame((Object)doner1.socket, (Object)seeker1.socket);
        SocketDealerTest.assertSame((Object)doner2.socket, (Object)seeker2.socket);
    }

    public void testSeekerRemovedAfterDeltTo() throws Exception {
        this.doSimpleDealing();
        Collection waiting = this.dealer.getWaitingList();
        SocketDealerTest.assertEquals((int)0, (int)waiting.size());
    }

    public void testSeekerIsWaiting() throws Exception {
        SocketDealerTest.assertFalse((boolean)this.dealer.isWaiting(23));
        int ticket = this.dealer.seekingSocket((SocketSeeker)new SimpleSocketSeeker());
        SocketDealerTest.assertTrue((boolean)this.dealer.isWaiting(ticket));
    }
}

