/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fitnesse.fixtures.FitnesseFixtureContext;
import fitnesse.fixtures.ResponseExaminer;
import fitnesse.http.MockResponseSender;
import fitnesse.http.SimpleResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResponseExaminerTest {
    private ResponseExaminer examiner;

    @Before
    public void setup() throws Exception {
        this.examiner = new ResponseExaminer();
        FitnesseFixtureContext.sender = new MockResponseSender();
        FitnesseFixtureContext.sender.send("&lt;hello".getBytes());
        FitnesseFixtureContext.response = new SimpleResponse();
        FitnesseFixtureContext.response.setStatus(42);
    }

    @Test
    public void shouldBeAbleToExtractContents() throws Exception {
        this.examiner.type = "contents";
        this.examiner.extractValueFromResponse();
        Assert.assertEquals((Object)"<hello", (Object)this.examiner.getValue());
    }

    @Test
    public void shouldBeAbleToExtractFullContents() throws Exception {
        this.examiner.type = "fullContents";
        this.examiner.extractValueFromResponse();
        Assert.assertEquals((Object)"&amp;lt;hello", (Object)this.examiner.getValue());
    }

    @Test
    public void shouldBeAbleToExtractStatus() throws Exception {
        this.examiner.type = "status";
        this.examiner.extractValueFromResponse();
        Assert.assertEquals((Object)"42", (Object)this.examiner.getValue());
    }

    @Test
    public void shouldBeAbleToExtractHeaders() throws Exception {
        FitnesseFixtureContext.sender = new MockResponseSender();
        FitnesseFixtureContext.sender.send("Headers \r\n\r\n bleh".getBytes());
        this.examiner.type = "headers";
        this.examiner.extractValueFromResponse();
        Assert.assertEquals((Object)"Headers \r\n", (Object)this.examiner.getValue());
    }
}

