/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.InputStreamResponse;
import fitnesse.http.ResponseParser;
import fitnesse.http.ResponseSender;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import util.FileUtil;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class InputStreamResponseTest
extends RegexTestCase
implements ResponseSender {
    private InputStreamResponse response;
    private boolean closed = false;
    private ByteArrayOutputStream output;
    private File testFile = new File("testFile.test");
    private long bytesSent = 0L;

    public void setUp() throws Exception {
        this.response = new InputStreamResponse();
        this.output = new ByteArrayOutputStream();
    }

    public void tearDown() throws Exception {
        FileUtil.deleteFile((File)this.testFile);
    }

    public void testSimpleUsage() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream("content".getBytes());
        this.response.setBody((InputStream)input, 7);
        this.response.sendTo((ResponseSender)this);
        InputStreamResponseTest.assertTrue((boolean)this.closed);
        ResponseParser result = new ResponseParser((InputStream)new ByteArrayInputStream(this.output.toByteArray()));
        InputStreamResponseTest.assertEquals((int)200, (int)result.getStatus());
        InputStreamResponseTest.assertEquals((String)"7", (String)result.getHeader("Content-Length"));
        InputStreamResponseTest.assertEquals((String)"content", (String)result.getBody());
    }

    public void testWithFile() throws Exception {
        FileUtil.createFile((File)this.testFile, (String)"content");
        this.response.setBody(this.testFile);
        this.response.sendTo((ResponseSender)this);
        InputStreamResponseTest.assertTrue((boolean)this.closed);
        ResponseParser result = new ResponseParser((InputStream)new ByteArrayInputStream(this.output.toByteArray()));
        InputStreamResponseTest.assertEquals((int)200, (int)result.getStatus());
        InputStreamResponseTest.assertEquals((String)"7", (String)result.getHeader("Content-Length"));
        InputStreamResponseTest.assertEquals((String)"content", (String)result.getBody());
    }

    public void testWithLargeFile() throws Exception {
        this.writeLinesToFile(1000);
        this.response.setBody(this.testFile);
        this.response.sendTo((ResponseSender)this);
        String responseString = this.output.toString();
        InputStreamResponseTest.assertSubString((String)"Content-Length: 100000", (String)responseString);
        InputStreamResponseTest.assertTrue((this.bytesSent > 100000L ? 1 : 0) != 0);
    }

    public void testWithLargerFile() throws Exception {
        this.writeLinesToFile(100000);
        this.response.setBody(this.testFile);
        this.response.sendTo((ResponseSender)this);
        String responseString = this.output.toString();
        InputStreamResponseTest.assertSubString((String)"Content-Length: 10000000", (String)responseString);
        InputStreamResponseTest.assertTrue((this.bytesSent > 10000000L ? 1 : 0) != 0);
    }

    public void _testWithReallyBigFile() throws Exception {
        this.writeLinesToFile(10000000);
        this.response.setBody(this.testFile);
        this.response.sendTo((ResponseSender)this);
        String responseString = this.output.toString();
        InputStreamResponseTest.assertSubString((String)"Content-Length: 1000000000", (String)responseString);
        InputStreamResponseTest.assertTrue((this.bytesSent > 1000000000L ? 1 : 0) != 0);
    }

    private void writeLinesToFile(int lines) throws IOException {
        String sampleLine = "This is a sample line of a large file that's created for the large file tests. It's 100 bytes long.\n";
        byte[] bytes = sampleLine.getBytes();
        FileOutputStream testFileOutput = new FileOutputStream(this.testFile);
        for (int i = 0; i < lines; ++i) {
            testFileOutput.write(bytes);
        }
        testFileOutput.close();
    }

    public void send(byte[] bytes) {
        if (this.bytesSent < 500L) {
            try {
                this.output.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.bytesSent += (long)bytes.length;
    }

    public void close() {
        this.closed = true;
    }

    public Socket getSocket() {
        return null;
    }
}

