/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Request;
import fitnesse.http.UploadedFile;
import fitnesse.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import junit.framework.TestCase;
import util.FileUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class RequestTest
extends TestCase {
    PipedOutputStream output;
    Request request;
    public Thread parseThread;
    public Exception exception;
    ByteArrayOutputStream messageBuffer;

    public void setUp() throws Exception {
        this.output = new PipedOutputStream();
        this.request = new Request((InputStream)new PipedInputStream(this.output));
        this.messageBuffer = new ByteArrayOutputStream();
    }

    public void tearDown() throws Exception {
        this.output.close();
    }

    private void appendToMessage(StringBuffer buffer) throws Exception {
        this.messageBuffer.write(buffer.toString().getBytes());
    }

    private void appendToMessage(String value) throws Exception {
        this.messageBuffer.write(value.getBytes());
    }

    private void appendToMessage(byte[] bytes) throws Exception {
        this.messageBuffer.write(bytes);
    }

    private void parseMessage() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.messageBuffer.toByteArray());
        this.request = new Request((InputStream)stream);
        try {
            this.request.parse();
        }
        catch (Exception record) {
            this.exception = record;
        }
    }

    public void testMultilevelRequest() throws Exception {
        this.appendToMessage("GET /SomePage.SubPage?edit HTTP/1.1\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        RequestTest.assertEquals((String)"SomePage.SubPage", (String)this.request.getResource());
    }

    public void testSimpleRequest() throws Exception {
        RequestTest.assertFalse((boolean)this.request.hasBeenParsed());
        this.appendToMessage("GET /request-uri HTTP/1.1\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        RequestTest.assertTrue((boolean)this.request.hasBeenParsed());
        RequestTest.assertEquals((String)"/request-uri", (String)this.request.getRequestUri());
    }

    public void testMalformedRequestLine() throws Exception {
        this.appendToMessage("/resource HTTP/1.1\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        RequestTest.assertNotNull((String)"no exception was thrown", (Object)this.exception);
        RequestTest.assertEquals((String)"The request string is malformed and can not be parsed", (String)this.exception.getMessage());
    }

    public void testBadMethod() throws Exception {
        this.appendToMessage("DELETE /resource HTTP/1.1\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        RequestTest.assertNotNull((String)"no exception was thrown", (Object)this.exception);
        RequestTest.assertEquals((String)"The DELETE method is not currently supported", (String)this.exception.getMessage());
    }

    public void testQueryStringValueWithNoQueryString() throws Exception {
        this.appendToMessage("GET /resource HTTP/1.1\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        RequestTest.assertEquals((String)"", (String)this.request.getQueryString());
    }

    public void testParsingRequestUri() throws Exception {
        this.appendToMessage("GET /resource?queryString HTTP/1.1\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        RequestTest.assertEquals((String)"resource", (String)this.request.getResource());
        RequestTest.assertEquals((String)"queryString", (String)this.request.getQueryString());
    }

    public void testCanGetQueryStringValues() throws Exception {
        this.appendToMessage("GET /resource?key1=value1&key2=value2 HTTP/1.1\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        this.checkInputs();
    }

    public void testHeaders() throws Exception {
        this.appendToMessage("GET /something HTTP/1.1\r\n");
        this.appendToMessage("Content-Length: 0\r\n");
        this.appendToMessage("Accept: text/html\r\n");
        this.appendToMessage("Connection: Keep-Alive\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        RequestTest.assertEquals((boolean)true, (boolean)this.request.hasHeader("Content-Length"));
        RequestTest.assertEquals((Object)"0", (Object)this.request.getHeader("Content-Length"));
        RequestTest.assertEquals((boolean)true, (boolean)this.request.hasHeader("Accept"));
        RequestTest.assertEquals((Object)"text/html", (Object)this.request.getHeader("Accept"));
        RequestTest.assertEquals((boolean)true, (boolean)this.request.hasHeader("Connection"));
        RequestTest.assertEquals((Object)"Keep-Alive", (Object)this.request.getHeader("Connection"));
        RequestTest.assertEquals((boolean)false, (boolean)this.request.hasHeader("Something-Else"));
        RequestTest.assertEquals(null, (Object)this.request.getHeader("Something-Else"));
    }

    public void testEntityBodyWithoutContentLength() throws Exception {
        this.appendToMessage("GET /something HTTP/1.1\r\n");
        this.appendToMessage("\r\nThis is the Entity Body");
        this.parseMessage();
        RequestTest.assertEquals((String)"", (String)this.request.getBody());
    }

    public void testEntityBodyIsRead() throws Exception {
        this.appendToMessage("GET /something HTTP/1.1\r\n");
        this.appendToMessage("Content-Length: 23\r\n");
        this.appendToMessage("\r\n");
        this.appendToMessage("This is the Entity Body");
        this.parseMessage();
        RequestTest.assertEquals((String)"This is the Entity Body", (String)this.request.getBody());
    }

    public void testEntityBodyParametersAreParsed() throws Exception {
        this.appendToMessage("GET /something HTTP/1.1\r\n");
        this.appendToMessage("Content-Length: 23\r\n");
        this.appendToMessage("\r\n");
        this.appendToMessage("key1=value1&key2=value2");
        this.parseMessage();
        this.checkInputs();
    }

    private void checkInputs() {
        RequestTest.assertEquals((boolean)true, (boolean)this.request.hasInput("key1"));
        RequestTest.assertEquals((Object)"value1", (Object)this.request.getInput("key1"));
        RequestTest.assertEquals((boolean)true, (boolean)this.request.hasInput("key2"));
        RequestTest.assertEquals((Object)"value2", (Object)this.request.getInput("key2"));
        RequestTest.assertEquals((boolean)false, (boolean)this.request.hasInput("someOtherKey"));
        RequestTest.assertEquals(null, (Object)this.request.getInput("someOtherKey"));
    }

    public void testPostMethod() throws Exception {
        this.appendToMessage("POST /something HTTP/1.1\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        RequestTest.assertNull((String)"POST method should be allowed", (Object)this.exception);
    }

    public void testSimpleInputStyle() throws Exception {
        this.appendToMessage("GET /abc?something HTTP/1.1\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        RequestTest.assertEquals((boolean)true, (boolean)this.request.hasInput("something"));
    }

    public void testOperaPostRequest() throws Exception {
        this.appendToMessage("POST /HelloThere HTTP/1.1\r\n");
        this.appendToMessage("User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; MSIE 5.5; Windows NT 5.1) Opera 7.02  [en]\r\n");
        this.appendToMessage("Host: localhost:75\r\n");
        this.appendToMessage("Accept: text/html, image/png, image/jpeg, image/gif, image/x-xbitmap, */*;q=0.1\r\n");
        this.appendToMessage("Accept-Language: en\r\n");
        this.appendToMessage("Accept-Charset: windows-1252, utf-8, utf-16, iso-8859-1;q=0.6, *;q=0.1\r\n");
        this.appendToMessage("Accept-Encoding: deflate, gzip, x-gzip, identity, *;q=0\r\n");
        this.appendToMessage("Referer: http://localhost:75/HeloThere?edit=\r\n");
        this.appendToMessage("Connection: Keep-Alive, TE\r\n");
        this.appendToMessage("TE: deflate, gzip, chunked, identity, trailers\r\n");
        this.appendToMessage("Content-type: application/x-www-form-urlencoded\r\n");
        this.appendToMessage("Content-length: 67\r\n");
        this.appendToMessage("\r\n");
        this.appendToMessage("editTime=1046584670887&Edit=on&Search=on&Test=on&Suite=on&content=abc");
        this.parseMessage();
        RequestTest.assertTrue((boolean)this.request.hasInput("editTime"));
        RequestTest.assertTrue((boolean)this.request.hasInput("Edit"));
        RequestTest.assertTrue((boolean)this.request.hasInput("Search"));
        RequestTest.assertTrue((boolean)this.request.hasInput("Test"));
        RequestTest.assertTrue((boolean)this.request.hasInput("Suite"));
        RequestTest.assertTrue((boolean)this.request.hasInput("content"));
    }

    public void testBigPosts() throws Exception {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 1000; ++j) {
                buffer.append(i);
            }
        }
        String prefix = "editTime=12345&content=";
        this.appendToMessage("POST /HelloThere HTTP/1.1\r\n");
        this.appendToMessage(String.format("Content-length: %d\r\n", prefix.length() + buffer.length()));
        this.appendToMessage("\r\n");
        this.appendToMessage(prefix);
        this.appendToMessage(buffer);
        this.parseMessage();
        String expected = buffer.toString();
        String actual = (String)this.request.getInput("content");
        RequestTest.assertEquals((int)expected.length(), (int)actual.length());
        RequestTest.assertEquals((String)expected, (String)actual);
    }

    public void testMultiPartForms() throws Exception {
        String content = "----bob\r\nContent-Disposition: form-data; name=\"key1\"\r\n\r\nvalue1\r\n----bob\r\nContent-Disposition: form-data; name=\"key3\"\r\n\r\nsome\r\nmulti-line\r\nvalue\r\n\r\n----bob\r\nContent-Disposition: form-data; name=\"key2\"\r\n\r\nvalue2\r\n----bob\r\nContent-Disposition: form-data; name=\"key4\"\r\n\r\n\r\n----bob--\r\n";
        this.appendToMessage("GET /request-uri HTTP/1.1\r\n");
        this.appendToMessage("Content-Length: " + content.length() + "\r\n");
        this.appendToMessage("Content-Type: multipart/form-data; boundary=--bob\r\n");
        this.appendToMessage("\r\n");
        this.appendToMessage(content);
        this.parseMessage();
        if (this.exception != null) {
            throw this.exception;
        }
        this.checkInputs();
        RequestTest.assertEquals((boolean)true, (boolean)this.request.hasInput("key3"));
        RequestTest.assertEquals((Object)"some\r\nmulti-line\r\nvalue\r\n", (Object)this.request.getInput("key3"));
        RequestTest.assertEquals((boolean)true, (boolean)this.request.hasInput("key4"));
        RequestTest.assertEquals((Object)"", (Object)this.request.getInput("key4"));
    }

    public void testUploadingFile() throws Exception {
        String content = "----bob\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"mike dile.txt\"\r\nContent-Type: text/plain\r\n\r\nfile contents\r\n----bob--\r\n";
        this.appendToMessage("GET /request-uri HTTP/1.1\r\n");
        this.appendToMessage("Content-Length: " + content.length() + "\r\n");
        this.appendToMessage("Content-Type: multipart/form-data; boundary=--bob\r\n");
        this.appendToMessage("\r\n");
        this.appendToMessage(content);
        this.parseMessage();
        this.testUploadedFile("file1", "mike dile.txt", "text/plain", "file contents");
    }

    public void testUploadingTwoFiles() throws Exception {
        String content = "-----------------------------7d32df3a80058\r\nContent-Disposition: form-data; name=\"file\"; filename=\"C:\\test.txt\"\r\nContent-Type: text/plain\r\n\r\ntest\r\n-----------------------------7d32df3a80058\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"C:\\test2.txt\"\r\nContent-Type: text/plain\r\n\r\ntest2\r\n-----------------------------7d32df3a80058--\r\n";
        this.appendToMessage("GET /request-uri HTTP/1.1\r\n");
        this.appendToMessage("Content-Length: " + content.length() + "\r\n");
        this.appendToMessage("Content-Type: multipart/form-data; boundary=---------------------------7d32df3a80058\r\n");
        this.appendToMessage("\r\n");
        this.appendToMessage(content);
        this.parseMessage();
        this.testUploadedFile("file", "C:\\test.txt", "text/plain", "test");
        this.testUploadedFile("file2", "C:\\test2.txt", "text/plain", "test2");
    }

    private void testUploadedFile(String name, String filename, String contentType, String content) throws Exception {
        RequestTest.assertEquals((boolean)true, (boolean)this.request.hasInput(name));
        UploadedFile file = (UploadedFile)this.request.getInput(name);
        RequestTest.assertNotNull((Object)file);
        RequestTest.assertEquals((String)filename, (String)file.getName());
        RequestTest.assertEquals((String)contentType, (String)file.getType());
        RequestTest.assertEquals((String)content, (String)FileUtil.getFileContent((File)file.getFile()));
    }

    public void testUploadingBinaryFile() throws Exception {
        this.appendToMessage("GET /request-uri HTTP/1.1\r\n");
        this.appendToMessage("Content-Length: 83\r\n");
        this.appendToMessage("Content-Type: multipart/form-data; boundary=--bob\r\n");
        this.appendToMessage("\r\n");
        this.appendToMessage("----bob\r\n");
        this.appendToMessage("Content-Disposition: name=\"n\"; filename=\"f\"\r\n");
        this.appendToMessage("\r\n");
        this.appendToMessage(new byte[]{-99, -112, -127});
        this.appendToMessage("file contents");
        this.appendToMessage("\r\n");
        this.appendToMessage("----bob--");
        this.parseMessage();
        UploadedFile file = (UploadedFile)this.request.getInput("n");
        RequestTest.assertNotNull((Object)file);
        byte[] contents = FileUtil.getFileBytes((File)file.getFile());
        RequestTest.assertEquals((byte)-99, (byte)contents[0]);
        RequestTest.assertEquals((byte)-112, (byte)contents[1]);
        RequestTest.assertEquals((byte)-127, (byte)contents[2]);
        RequestTest.assertEquals((String)"file contents", (String)new String(contents, 3, contents.length - 3));
    }

    public void testCanGetCredentials() throws Exception {
        this.appendToMessage("GET /abc?something HTTP/1.1\r\n");
        this.appendToMessage("Authorization: Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        this.request.getCredentials();
        RequestTest.assertEquals((String)"Aladdin", (String)this.request.getAuthorizationUsername());
        RequestTest.assertEquals((String)"open sesame", (String)this.request.getAuthorizationPassword());
    }

    public void testDoenstChokeOnMissingPassword() throws Exception {
        this.appendToMessage("GET /abc?something HTTP/1.1\r\n");
        this.appendToMessage("Authorization: Basic " + Base64.encode((String)"Aladin") + "\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        this.request.getCredentials();
    }

    public void testGetUserpass() throws Exception {
        RequestTest.assertEquals((String)"Aladdin:open sesame", (String)this.request.getUserpass("Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ=="));
    }

    public void testUnicodeCharacters() throws Exception {
        this.appendToMessage("GET /?key=%EB%AA%80%EB%AA%81%EB%AA%82%EB%AA%83 HTTP/1.1\r\n\r\n");
        this.parseMessage();
        RequestTest.assertEquals((Object)"\uba80\uba81\uba82\uba83", (Object)this.request.getInput("key"));
    }

    public void testParsingProgress() throws Exception {
        this.appendToMessage("GET /something HTTP/1.1\r\n");
        this.appendToMessage("Content-Length: 23\r\n");
        this.appendToMessage("\r\n");
        this.appendToMessage("This is ");
        this.appendToMessage("the Entity Body");
        this.parseMessage();
        RequestTest.assertEquals((long)70L, (long)this.request.numberOfBytesParsed());
    }

    public void testMultipleRequests() throws Exception {
        this.appendToMessage("GET /resource?key1=value1&key1=value2 HTTP/1.1\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        RequestTest.assertEquals((boolean)true, (boolean)this.request.hasInput("key1"));
        RequestTest.assertEquals((Object)"value1,value2", (Object)this.request.getInput("key1"));
    }

    public void testRequestWithSameValue() throws Exception {
        this.appendToMessage("GET /resource?key1=value1&key1=value1 HTTP/1.1\r\n");
        this.appendToMessage("\r\n");
        this.parseMessage();
        RequestTest.assertEquals((boolean)true, (boolean)this.request.hasInput("key1"));
        RequestTest.assertEquals((Object)"value1", (Object)this.request.getInput("key1"));
    }
}

