/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.ResponseSender;
import fitnesse.http.SimpleResponse;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimpleResponseTest
extends RegexTestCase
implements ResponseSender {
    private StringBuffer buffer;
    private String text;
    private boolean closed = false;

    public void send(byte[] bytes) {
        try {
            this.buffer.append(new String(bytes, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.text = this.buffer.toString();
    }

    public void close() {
        this.closed = true;
    }

    public Socket getSocket() {
        return null;
    }

    public void setUp() throws Exception {
        this.buffer = new StringBuffer();
        this.text = null;
    }

    public void tearDown() throws Exception {
    }

    public void testSimpleResponse() {
        SimpleResponse response = new SimpleResponse();
        response.setContent("some content");
        response.sendTo((ResponseSender)this);
        SimpleResponseTest.assertTrue((boolean)this.text.startsWith("HTTP/1.1 200 OK\r\n"));
        SimpleResponseTest.assertHasRegexp((String)"Content-Length: 12", (String)this.text);
        SimpleResponseTest.assertHasRegexp((String)"Content-Type: text/html", (String)this.text);
        SimpleResponseTest.assertTrue((boolean)this.text.endsWith("some content"));
        SimpleResponseTest.assertTrue((boolean)this.closed);
    }

    public void testPageNotFound() throws Exception {
        SimpleResponse response = new SimpleResponse(404);
        response.sendTo((ResponseSender)this);
        SimpleResponseTest.assertHasRegexp((String)"404 Not Found", (String)this.text);
    }

    public void testRedirect() throws Exception {
        SimpleResponse response = new SimpleResponse();
        response.redirect("some url");
        response.sendTo((ResponseSender)this);
        SimpleResponseTest.assertEquals((int)303, (int)response.getStatus());
        SimpleResponseTest.assertHasRegexp((String)"Location: some url\r\n", (String)this.text);
    }

    public void testUnicodeCharacters() {
        SimpleResponse response = new SimpleResponse();
        response.setContent("\uba80\uba81\uba82\uba83");
        response.sendTo((ResponseSender)this);
        SimpleResponseTest.assertSubString((String)"\uba80\uba81\uba82\uba83", (String)this.text);
    }
}

