/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.Arguments;
import fitnesse.junit.PrintTestListener;
import fitnesse.responders.run.JavaFormatter;
import fitnesse.responders.run.ResultsListener;
import fitnesse.testsystems.TestSummary;
import fitnesseMain.FitNesseMain;

public class TestHelper {
    private final String fitNesseRootPath;
    private final String outputPath;
    private final ResultsListener resultListener;
    private boolean debug = true;
    public static final String PAGE_TYPE_SUITE = "suite";
    public static final String PAGE_TYPE_TEST = "test";
    private static final String COMMON_ARGS = "&nohistory=true&format=java";
    private static final String DEBUG_ARG = "&debug=true";

    public TestHelper(String fitNesseRootPath, String outputPath) {
        this(fitNesseRootPath, outputPath, (ResultsListener)new PrintTestListener());
    }

    public TestHelper(String fitNesseRootPath, String outputPath, ResultsListener resultListener) {
        this.fitNesseRootPath = fitNesseRootPath;
        this.outputPath = outputPath;
        this.resultListener = resultListener;
    }

    public TestSummary runSuite(String suiteName) throws Exception {
        return this.run(suiteName, PAGE_TYPE_SUITE);
    }

    public TestSummary runSuite(String suiteName, String suiteFilter) throws Exception {
        return this.run(suiteName, PAGE_TYPE_SUITE, suiteFilter);
    }

    public TestSummary runTest(String suiteName) throws Exception {
        return this.run(suiteName, PAGE_TYPE_TEST);
    }

    public TestSummary run(String pageName, String pageType) throws Exception {
        return this.run(pageName, pageType, null);
    }

    public TestSummary run(String pageName, String pageType, String suiteFilter, int port) throws Exception {
        return this.run(pageName, pageType, suiteFilter, null, port);
    }

    public TestSummary run(String pageName, String pageType, String suiteFilter, String excludeSuiteFilter, int port) throws Exception {
        JavaFormatter testFormatter = JavaFormatter.getInstance((String)pageName);
        testFormatter.setResultsRepository((JavaFormatter.ResultsRepository)new JavaFormatter.FolderResultsRepository(this.outputPath));
        testFormatter.setListener(this.resultListener);
        Arguments arguments = new Arguments();
        arguments.setDaysTillVersionsExpire("0");
        arguments.setInstallOnly(false);
        arguments.setOmitUpdates(true);
        arguments.setPort(String.valueOf(port));
        arguments.setRootPath(this.fitNesseRootPath);
        arguments.setCommand(this.getCommand(pageName, pageType, suiteFilter, excludeSuiteFilter));
        FitNesseMain.dontExitAfterSingleCommand = true;
        FitNesseMain.launchFitNesse((Arguments)arguments);
        return testFormatter.getTotalSummary();
    }

    public TestSummary run(String pageName, String pageType, String suiteFilter) throws Exception {
        return this.run(pageName, pageType, suiteFilter, 0);
    }

    String getCommand(String pageName, String pageType, String suiteFilter, String excludeSuiteFilter) {
        String command = pageName + "?" + pageType + this.getCommandArgs();
        if (suiteFilter != null) {
            command = command + "&suiteFilter=" + suiteFilter;
        }
        if (excludeSuiteFilter != null) {
            command = command + "&excludeSuiteFilter=" + excludeSuiteFilter;
        }
        return command;
    }

    private String getCommandArgs() {
        if (this.debug) {
            return "&debug=true&nohistory=true&format=java";
        }
        return COMMON_ARGS;
    }

    public void setDebugMode(boolean enabled) {
        this.debug = enabled;
    }
}

