/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.responders.BasicWikiPageResponder;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import util.StringUtil;

public class NameWikiPageResponder
extends BasicWikiPageResponder {
    protected String contentFrom(WikiPage requestedPage) {
        List lines = this.addLines(requestedPage);
        String format = (String)this.request.getInput("format");
        if ("json".equalsIgnoreCase(format)) {
            JSONArray jsonPages = new JSONArray((Collection)lines);
            return jsonPages.toString();
        }
        return StringUtil.join((List)lines, (String)System.getProperty("line.separator"));
    }

    private List<String> addLines(WikiPage requestedPage) {
        ArrayList<String> lines = new ArrayList<String>();
        for (WikiPage child : requestedPage.getChildren()) {
            lines.add(this.makeLine(child));
        }
        return lines;
    }

    private String makeLine(WikiPage child) {
        String line;
        if (this.request.hasInput("ShowChildCount")) {
            int numberOfChildren = child.getChildren().size();
            line = child.getName() + " " + numberOfChildren;
        } else {
            line = child.getName();
        }
        return line;
    }

    protected String getContentType() {
        return "text/plain";
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

