/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.RssResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class RssResponder
implements SecureResponder {
    private RssFeed feed;

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        WikiPage contextPage = this.getContextPage(context, request.getResource());
        WikiPage recentChangesPage = context.root.getChildPage("RecentChanges");
        this.feed = new RssFeed(this.getConfiguredRssLinkPrefixFrom(contextPage));
        this.buildItemReportIfRecentChangesExists(recentChangesPage, request.getResource());
        return this.feed.asResponse();
    }

    private WikiPage getContextPage(FitNesseContext context, String resource) throws Exception {
        PageCrawler pageCrawler = context.root.getPageCrawler();
        WikiPagePath resourcePath = PathParser.parse((String)resource);
        return pageCrawler.getPage(context.root, resourcePath);
    }

    protected void buildItemReportIfRecentChangesExists(WikiPage recentChangesPage, String resource) throws Exception {
        if (recentChangesPage != null) {
            this.buildItemReport(resource, new RecentChangesPage(recentChangesPage));
        }
    }

    private void buildItemReport(String resource, RecentChangesPage recentChangesPage) throws Exception {
        for (RecentChangesPageEntry line : recentChangesPage.getLinesApplicableTo(resource)) {
            this.feed.addItem(line);
        }
    }

    private String getConfiguredRssLinkPrefixFrom(WikiPage contextPage) throws Exception {
        if (contextPage == null) {
            return null;
        }
        PageData data = contextPage.getData();
        return data.getVariable("RSS_PREFIX");
    }

    protected static boolean isNeitherNullNorBlank(String string) {
        return string != null && string.length() > 0;
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

