/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureWriteOperation;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.parser.WikiWordPath;

public class AddChildPageResponder
implements SecureResponder {
    private WikiPage currentPage;
    private PageCrawler crawler;
    private String childName;
    private WikiPagePath currentPagePath;
    private WikiPagePath childPath;
    private String childContent;
    private String pageType;
    private String helpText;
    private String suites;

    public SecureOperation getSecureOperation() {
        return new SecureWriteOperation();
    }

    public Response makeResponse(FitNesseContext context, Request request) {
        this.parseRequest(context, request);
        if (this.currentPage == null) {
            return this.notFoundResponse(context, request);
        }
        if (this.nameIsInvalid(this.childName)) {
            return this.errorResponse(context, request);
        }
        return this.createChildPageAndMakeResponse(request);
    }

    private void parseRequest(FitNesseContext context, Request request) {
        this.childName = (String)request.getInput("pageName");
        this.childName = this.childName == null ? "null" : this.childName;
        this.childPath = PathParser.parse((String)this.childName);
        this.currentPagePath = PathParser.parse((String)request.getResource());
        this.crawler = context.root.getPageCrawler();
        this.currentPage = this.crawler.getPage(context.root, this.currentPagePath);
        this.childContent = (String)request.getInput("pageContent");
        this.pageType = (String)request.getInput("pageType");
        this.helpText = (String)request.getInput("helpText");
        this.suites = (String)request.getInput("suites");
        if (this.childContent == null) {
            this.childContent = "!contents\n";
        }
        if (this.pageType == null) {
            this.pageType = "Default";
        }
    }

    private Response createChildPageAndMakeResponse(Request request) {
        this.createChildPage(request);
        SimpleResponse response = new SimpleResponse();
        WikiPagePath fullPathOfCurrentPage = this.crawler.getFullPath(this.currentPage);
        response.redirect(fullPathOfCurrentPage.toString());
        return response;
    }

    private boolean nameIsInvalid(String name) {
        if (name.equals("")) {
            return true;
        }
        return !WikiWordPath.isSingleWikiWord((String)name);
    }

    private void createChildPage(Request request) {
        WikiPage childPage = this.crawler.addPage(this.currentPage, this.childPath, this.childContent);
        this.setAttributes(childPage);
    }

    private void setAttributes(WikiPage childPage) {
        PageData childPageData = childPage.getData();
        if (this.pageType.equals("Static")) {
            childPageData.getProperties().remove("Test");
            childPageData.getProperties().remove("Suite");
        } else if ("Test".equals(this.pageType) || "Suite".equals(this.pageType)) {
            childPageData.setAttribute(this.pageType);
        }
        childPageData.setAttribute("Help", this.helpText);
        childPageData.setAttribute("Suites", this.suites);
        childPage.commit(childPageData);
    }

    private Response errorResponse(FitNesseContext context, Request request) {
        return new ErrorResponder("Invalid Child Name").makeResponse(context, request);
    }

    private Response notFoundResponse(FitNesseContext context, Request request) {
        return new NotFoundResponder().makeResponse(context, request);
    }
}

