/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.EditResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class EditResponderTest
extends RegexTestCase {
    private WikiPage root;
    private MockRequest request;
    private EditResponder responder;
    private PageCrawler crawler;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        FitNesseContext context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.crawler = this.root.getPageCrawler();
        this.request = new MockRequest();
        this.responder = new EditResponder();
    }

    public void testResponse() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"ChildPage"), "child content with <html>");
        PageData data = page.getData();
        WikiPageProperties properties = data.getProperties();
        properties.set("Suites", "Edit Page tags");
        page.commit(data);
        SimpleResponse response = this.makeResponse();
        EditResponderTest.assertEquals((int)200, (int)response.getStatus());
        String body = response.getContent();
        EditResponderTest.assertSubString((String)"<html>", (String)body);
        EditResponderTest.assertSubString((String)"<form", (String)body);
        EditResponderTest.assertSubString((String)"method=\"post\"", (String)body);
        EditResponderTest.assertSubString((String)"child content with &lt;html&gt;", (String)body);
        EditResponderTest.assertSubString((String)"name=\"responder\"", (String)body);
        EditResponderTest.assertSubString((String)"name=\"editTime\"", (String)body);
        EditResponderTest.assertSubString((String)"name=\"ticketId\"", (String)body);
        EditResponderTest.assertSubString((String)"name=\"helpText\"", (String)body);
        EditResponderTest.assertSubString((String)"select id=\"templateMap\"", (String)body);
        EditResponderTest.assertSubString((String)"type=\"submit\"", (String)body);
        EditResponderTest.assertSubString((String)String.format("textarea", "pageContent"), (String)body);
        EditResponderTest.assertSubString((String)"<h5> Edit Page tags</h5>", (String)body);
    }

    private SimpleResponse makeResponse() {
        this.request.setResource("ChildPage");
        return (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
    }

    public void testResponseWhenNonexistentPageRequestsed() throws Exception {
        this.request.setResource("NonExistentPage");
        this.request.addInput("nonExistent", (Object)true);
        FitNesseContext context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(context, (Request)this.request);
        EditResponderTest.assertEquals((int)200, (int)response.getStatus());
        String body = response.getContent();
        EditResponderTest.assertSubString((String)"<html>", (String)body);
        EditResponderTest.assertSubString((String)"<form", (String)body);
        EditResponderTest.assertSubString((String)"method=\"post\"", (String)body);
        EditResponderTest.assertSubString((String)context.defaultNewPageContent, (String)body);
        EditResponderTest.assertSubString((String)"name=\"responder\"", (String)body);
        EditResponderTest.assertSubString((String)"name=\"editTime\"", (String)body);
        EditResponderTest.assertSubString((String)"name=\"ticketId\"", (String)body);
        EditResponderTest.assertSubString((String)"type=\"submit\"", (String)body);
        EditResponderTest.assertNotSubString((String)"<h5> </h5>", (String)body);
    }

    public void testRedirectToRefererEffect() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"ChildPage"), "child content with <html>");
        this.request.setResource("ChildPage");
        this.request.addInput("redirectToReferer", (Object)true);
        this.request.addInput("redirectAction", (Object)"boom");
        this.request.addHeader("Referer", (Object)"http://fitnesse.org:8080/SomePage");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        EditResponderTest.assertEquals((int)200, (int)response.getStatus());
        String body = response.getContent();
        EditResponderTest.assertSubString((String)"name=\"redirect\" value=\"http://fitnesse.org:8080/SomePage?boom\"", (String)body);
    }

    public void testTemplateListPopulates() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"TemplateLibrary"), "template library");
        this.crawler.addPage(this.root, PathParser.parse((String)"TemplateLibrary.TemplateOne"), "template 1");
        this.crawler.addPage(this.root, PathParser.parse((String)"TemplateLibrary.TemplateTwo"), "template 2");
        this.crawler.addPage(this.root, PathParser.parse((String)"ChildPage"), "child content with <html>");
        SimpleResponse response = this.makeResponse();
        EditResponderTest.assertEquals((int)200, (int)response.getStatus());
        String body = response.getContent();
        EditResponderTest.assertSubString((String)"<html>", (String)body);
        EditResponderTest.assertSubString((String)"<form", (String)body);
        EditResponderTest.assertSubString((String)"method=\"post\"", (String)body);
        EditResponderTest.assertSubString((String)"child content with &lt;html&gt;", (String)body);
        EditResponderTest.assertSubString((String)"name=\"responder\"", (String)body);
        EditResponderTest.assertSubString((String)"name=\"editTime\"", (String)body);
        EditResponderTest.assertSubString((String)"name=\"ticketId\"", (String)body);
        EditResponderTest.assertSubString((String)"name=\"helpText\"", (String)body);
        EditResponderTest.assertSubString((String)"select id=\"templateMap\"", (String)body);
        EditResponderTest.assertSubString((String)"option value=\".TemplateLibrary.TemplateOne\"", (String)body);
        EditResponderTest.assertSubString((String)"option value=\".TemplateLibrary.TemplateTwo\"", (String)body);
        EditResponderTest.assertSubString((String)"type=\"submit\"", (String)body);
        EditResponderTest.assertSubString((String)String.format("textarea", "pageContent"), (String)body);
    }

    public void testTemplateInserterScriptsExists() throws Exception {
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        String body = response.getContent();
        EditResponderTest.assertMatches((String)"TemplateInserter.js", (String)body);
    }

    public void testPasteFromExcelExists() throws Exception {
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        String body = response.getContent();
        EditResponderTest.assertMatches((String)"SpreadsheetTranslator.js", (String)body);
    }

    public void testFormatterScriptsExist() throws Exception {
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        String body = response.getContent();
        EditResponderTest.assertMatches((String)"WikiFormatter.js", (String)body);
    }

    public void testMissingPageDoesNotGetCreated() throws Exception {
        this.request.setResource("MissingPage");
        this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        EditResponderTest.assertFalse((boolean)this.root.hasChildPage("MissingPage"));
    }
}

