/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.NewPageResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class NewPageResponderTest
extends RegexTestCase {
    private WikiPage root;
    private MockRequest request;
    private NewPageResponder responder;
    private PageCrawler crawler;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.crawler = this.root.getPageCrawler();
        this.request = new MockRequest();
        this.responder = new NewPageResponder();
    }

    public void testResponse() throws Exception {
        this.request.setResource("root");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        NewPageResponderTest.assertEquals((int)200, (int)response.getStatus());
        String body = response.getContent();
        NewPageResponderTest.assertSubString((String)"<html>", (String)body);
        NewPageResponderTest.assertSubString((String)"<form", (String)body);
        NewPageResponderTest.assertSubString((String)"method=\"post\"", (String)body);
        NewPageResponderTest.assertSubString((String)"name=\"responder\"", (String)body);
        NewPageResponderTest.assertSubString((String)"name=\"helpText\"", (String)body);
        NewPageResponderTest.assertSubString((String)"type=\"submit\"", (String)body);
        NewPageResponderTest.assertSubString((String)"textarea class=\"wikitext no_wrap\"", (String)body);
    }

    public void testTemplateListPopulates() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"TemplateLibrary"), "template library");
        this.crawler.addPage(this.root, PathParser.parse((String)"TemplateLibrary.TemplateOne"), "template 1");
        this.crawler.addPage(this.root, PathParser.parse((String)"TemplateLibrary.TemplateTwo"), "template 2");
        this.crawler.addPage(this.root, PathParser.parse((String)"ChildPage"), "child content with <html>");
        this.request.setResource("ChildPage");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        NewPageResponderTest.assertEquals((int)200, (int)response.getStatus());
        String body = response.getContent();
        NewPageResponderTest.assertSubString((String)"<html>", (String)body);
        NewPageResponderTest.assertSubString((String)"<form", (String)body);
        NewPageResponderTest.assertSubString((String)"method=\"post\"", (String)body);
        NewPageResponderTest.assertSubString((String)"name=\"responder\"", (String)body);
        NewPageResponderTest.assertSubString((String)"name=\"helpText\"", (String)body);
        NewPageResponderTest.assertSubString((String)"select id=\"templateMap\"", (String)body);
        NewPageResponderTest.assertSubString((String)"option value=\".TemplateLibrary.TemplateOne\"", (String)body);
        NewPageResponderTest.assertSubString((String)"option value=\".TemplateLibrary.TemplateTwo\"", (String)body);
        NewPageResponderTest.assertSubString((String)"type=\"submit\"", (String)body);
        NewPageResponderTest.assertSubString((String)"textarea class=\"wikitext no_wrap\"", (String)body);
    }
}

