/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.files.DirectoryResponder;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import util.FileUtil;

public class DirectoryResponder
implements SecureResponder {
    private String resource;
    private File requestedDirectory;
    private FitNesseContext context;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy, hh:mm a");

    public DirectoryResponder(String resource, File requestedFile) {
        this.resource = resource;
        this.requestedDirectory = requestedFile;
    }

    public Response makeResponse(FitNesseContext context, Request request) {
        this.context = context;
        SimpleResponse simpleResponse = new SimpleResponse();
        if (!this.resource.endsWith("/")) {
            this.setRedirectForDirectory((Response)simpleResponse);
        } else {
            simpleResponse.setContent(this.makeDirectoryListingPage());
        }
        return simpleResponse;
    }

    private void setRedirectForDirectory(Response response) {
        if (!this.resource.startsWith("/")) {
            this.resource = "/" + this.resource;
        }
        response.redirect(this.resource + "/");
    }

    private String makeDirectoryListingPage() {
        HtmlPage page = this.context.pageFactory.newPage();
        page.setTitle("Files: " + this.resource);
        page.setPageTitle(new PageTitle("Files Section", this.resource, "/"));
        page.put("fileInfoList", (Object)this.makeFileInfo(FileUtil.getDirectoryListing((File)this.requestedDirectory)));
        page.setMainTemplate("directoryPage");
        return page.html();
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }

    private List<FileInfo> makeFileInfo(File[] files) {
        ArrayList<FileInfo> fileInfo = new ArrayList<FileInfo>();
        for (File file : files) {
            fileInfo.add(new FileInfo(this, file));
        }
        return fileInfo;
    }

    static /* synthetic */ SimpleDateFormat access$000(DirectoryResponder x0) {
        return x0.dateFormat;
    }
}

