/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.refactoring.SearchReplaceResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SearchReplaceResponderTest {
    private WikiPage root;
    private PageCrawler crawler;
    private SearchReplaceResponder responder;
    private MockRequest request;
    private FitNesseContext context;
    private WikiPagePath pagePath;
    private WikiPage somePage;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.pagePath = PathParser.parse((String)"SomePage");
        this.somePage = this.crawler.addPage(this.root, this.pagePath, "has something in it");
        this.responder = new SearchReplaceResponder();
        this.request = new MockRequest();
        this.request.setResource("SomePage");
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
    }

    @Test
    public void testSingleReplacementHtml() throws Exception {
        String content = this.getResponseContentUsingSearchReplaceString("something", "replacedthing");
        Assert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"replacedthing"));
        Assert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"SomePage"));
    }

    @Test
    public void multipleReplacements() throws Exception {
        this.crawler.addPage(this.somePage, PathParser.parse((String)"ChildPage"), "this page has something too.");
        String content = this.getResponseContentUsingSearchReplaceString("something", "replacedthing");
        Assert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"SomePage"));
        Assert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"ChildPage"));
    }

    @Test
    public void onlyReplacedPagesAreListed() throws Exception {
        this.crawler.addPage(this.somePage, PathParser.parse((String)"ChildPage"), "this page has nothing to replace.");
        String content = this.getResponseContentUsingSearchReplaceString("something", "replacedthing");
        Assert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"SomePage"));
        Assert.assertThat((Object)content, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ChildPage")));
    }

    @Test
    public void testReplacement() throws Exception {
        this.getResponseContentUsingSearchReplaceString("something", "replacedthing");
        WikiPage page = this.crawler.getPage(this.root, this.pagePath);
        Assert.assertThat((Object)page.getData().getContent(), (Matcher)Matchers.containsString((String)"has replacedthing in it"));
    }

    @Test
    public void noPageMatched() throws Exception {
        String content = this.getResponseContentUsingSearchReplaceString("non-available text", "replaced");
        Assert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"No pages matched your search criteria."));
    }

    @Test
    public void onlySelectedPageAndChildrenAreSearched() throws Exception {
        this.request.setResource("SomePage.ChildPage");
        this.crawler.addPage(this.somePage, PathParser.parse((String)"ChildPage"), "this page has something to replace.");
        String content = this.getResponseContentUsingSearchReplaceString("something", "replacedthing");
        Assert.assertThat((Object)content, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<a href=\"SomePage\">")));
        Assert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"SomePage.ChildPage"));
    }

    private String getResponseContentUsingSearchReplaceString(String searchString, String replacementString) throws Exception {
        this.request.addInput("searchString", (Object)searchString);
        this.request.addInput("replacementString", (Object)replacementString);
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        return sender.sentData();
    }
}

