/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseVersion;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.testsystems.TestSummary;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DateTimeUtil;
import util.StringUtil;
import util.TimeMeasurement;
import util.XmlUtil;

public abstract class ExecutionReport {
    public String version;
    public String rootPath;
    public TestSummary finalCounts = new TestSummary(0, 0, 0, 0);
    public Date date;
    protected Document xmlDoc;
    private long totalRunTimeInMillis = 0L;

    protected ExecutionReport(Document xmlDocument) {
        this();
        this.xmlDoc = xmlDocument;
    }

    protected ExecutionReport() {
        this.version = new FitNesseVersion().toString();
    }

    public String toString() {
        return this.rootPath;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExecutionReport)) {
            return false;
        }
        ExecutionReport e = (ExecutionReport)o;
        if (!StringUtil.stringsNullOrEqual((String)this.rootPath, (String)e.rootPath)) {
            return false;
        }
        if (!StringUtil.stringsNullOrEqual((String)this.version, (String)e.version)) {
            return false;
        }
        if (!DateTimeUtil.datesNullOrEqual((Date)this.date, (Date)e.date)) {
            return false;
        }
        if (!this.finalCounts.equals((Object)e.finalCounts)) {
            return false;
        }
        return this.totalRunTimeInMillis == e.totalRunTimeInMillis;
    }

    public static ExecutionReport makeReport(String xmlString) throws Exception {
        Document xmlDocument = XmlUtil.newDocument((String)xmlString);
        Element documentElement = xmlDocument.getDocumentElement();
        String documentNodeName = documentElement.getNodeName();
        if (documentNodeName.equals("testResults")) {
            return new TestExecutionReport(xmlDocument);
        }
        if (documentNodeName.equals("suiteResults")) {
            return new SuiteExecutionReport(xmlDocument);
        }
        throw new RuntimeException(String.format("%s is not a valid document element tag for an Execution Report.", documentNodeName));
    }

    protected void unpackCommonFields(Element documentElement) {
        this.version = XmlUtil.getTextValue((Element)documentElement, (String)"FitNesseVersion");
        this.rootPath = XmlUtil.getTextValue((Element)documentElement, (String)"rootPath");
        String dateString = XmlUtil.getTextValue((Element)documentElement, (String)"date");
        if (dateString != null) {
            this.date = DateTimeUtil.getDateFromString((String)dateString);
        }
        this.unpackFinalCounts(documentElement);
        this.totalRunTimeInMillis = this.getTotalRunTimeInMillisOrZeroIfNotPresent(documentElement);
    }

    protected long getTotalRunTimeInMillisOrZeroIfNotPresent(Element documentElement) {
        String textValue = XmlUtil.getTextValue((Element)documentElement, (String)"totalRunTimeInMillis");
        return textValue == null ? 0L : Long.parseLong(textValue);
    }

    private void unpackFinalCounts(Element testResults) {
        Element counts = XmlUtil.getElementByTagName((Element)testResults, (String)"finalCounts");
        if (counts != null) {
            this.finalCounts = new TestSummary(Integer.parseInt(XmlUtil.getTextValue((Element)counts, (String)"right")), Integer.parseInt(XmlUtil.getTextValue((Element)counts, (String)"wrong")), Integer.parseInt(XmlUtil.getTextValue((Element)counts, (String)"ignores")), Integer.parseInt(XmlUtil.getTextValue((Element)counts, (String)"exceptions")));
        }
    }

    protected void unpackXml() {
        Element historyDocument = this.xmlDoc.getDocumentElement();
        this.unpackCommonFields(historyDocument);
        this.unpackResults(historyDocument);
    }

    protected abstract void unpackResults(Element var1);

    public TestSummary getFinalCounts() {
        return this.finalCounts;
    }

    public String getVersion() {
        return this.version;
    }

    public long getTotalRunTimeInMillis() {
        return this.totalRunTimeInMillis;
    }

    public void setTotalRunTimeInMillis(TimeMeasurement totalTimeMeasurement) {
        this.totalRunTimeInMillis = totalTimeMeasurement.elapsed();
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public void setDate(Date date) {
        this.date = new Date(date.getTime());
    }

    public boolean hasRunTimes() {
        return new FitNesseVersion(this.getVersion()).isAtLeast("v20100607");
    }
}

