/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.formatters.XmlFormatter;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.WikiPage;
import java.io.IOException;
import util.TimeMeasurement;

public class SuiteXmlFormatter
extends XmlFormatter {
    private TestSummary xmlPageCounts = new TestSummary();

    public SuiteXmlFormatter(FitNesseContext context, WikiPage page, XmlFormatter.WriterFactory writerSource) {
        super(context, page, writerSource);
    }

    private void addFinalCounts() {
        this.testResponse.finalCounts = new TestSummary();
        this.finalSummary.right = this.testResponse.finalCounts.right = this.xmlPageCounts.getRight();
        this.finalSummary.wrong = this.testResponse.finalCounts.wrong = this.xmlPageCounts.getWrong();
        this.finalSummary.ignores = this.testResponse.finalCounts.ignores = this.xmlPageCounts.getIgnores();
        this.finalSummary.exceptions = this.testResponse.finalCounts.exceptions = this.xmlPageCounts.getExceptions();
    }

    public void testComplete(TestPage testPage, TestSummary testSummary, TimeMeasurement timeMeasurement) {
        PageCrawler pageCrawler = this.getPage().getPageCrawler();
        String relativeName = pageCrawler.getRelativeName(this.getPage(), testPage.getSourcePage());
        if ("".equals(relativeName)) {
            relativeName = String.format("(%s)", testPage.getName());
        }
        this.processTestResults(relativeName, testSummary, timeMeasurement);
        this.xmlPageCounts.tallyPageCounts(ExecutionResult.getExecutionResult((String)relativeName, (TestSummary)testSummary));
    }

    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws IOException {
        this.addFinalCounts();
        super.allTestingComplete(totalTimeMeasurement);
    }
}

