/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.responders.run.ExecutionStatus;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.testsystems.CompositeExecutionLog;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.WikiPage;
import java.io.IOException;
import util.TimeMeasurement;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class InteractiveFormatter
extends BaseFormatter {
    private static final String TESTING_INTERUPTED = "<strong>Testing was interupted and results are incomplete.</strong>&nbsp;";
    private boolean wasInterupted = false;
    private TestSummary assertionCounts = new TestSummary();
    private CompositeExecutionLog log;
    private String relativeName;

    protected InteractiveFormatter(FitNesseContext context, WikiPage page) {
        super(context, page);
    }

    protected abstract void writeData(String var1);

    protected void updateSummaryDiv(String html) {
        this.writeData(HtmlUtil.makeReplaceElementScript((String)"test-summary", (String)html).html());
    }

    protected String getRelativeName() {
        return this.relativeName;
    }

    protected String getRelativeName(TestPage testPage) {
        PageCrawler pageCrawler = this.getPage().getPageCrawler();
        String relativeName = pageCrawler.getRelativeName(this.getPage(), testPage.getSourcePage());
        if ("".equals(relativeName)) {
            relativeName = String.format("(%s)", testPage.getName());
        }
        return relativeName;
    }

    protected void addStopLink(String stopResponderId) {
        String link = "?responder=stoptest&id=" + stopResponderId;
        HtmlTag status = HtmlUtil.makeSilentLink((String)link, (HtmlElement)new RawHtml("Stop Test"));
        status.addAttribute("class", "stop");
        this.writeData(HtmlUtil.makeReplaceElementScript((String)"test-action", (String)status.html()).html());
    }

    protected void removeStopTestLink() {
        HtmlTag script = HtmlUtil.makeReplaceElementScript((String)"test-action", (String)"");
        this.writeData(script.html());
    }

    public TestSummary getAssertionCounts() {
        return this.assertionCounts;
    }

    public boolean wasInterupted() {
        return this.wasInterupted;
    }

    public void errorOccured() {
        this.wasInterupted = true;
        super.errorOccured();
    }

    public void newTestStarted(TestPage testPage, TimeMeasurement timeMeasurement) throws IOException {
        this.relativeName = this.getRelativeName(testPage);
    }

    public String testSummary() {
        String summaryContent = this.wasInterupted() ? "<strong>Testing was interupted and results are incomplete.</strong>&nbsp;" : "";
        summaryContent = summaryContent + this.makeSummaryContent();
        HtmlTag script = HtmlUtil.makeReplaceElementScript((String)"test-summary", (String)summaryContent);
        script.add("document.getElementById(\"test-summary\").className = \"" + ExecutionResult.getExecutionResult((String)this.relativeName, (TestSummary)this.getAssertionCounts()) + "\";");
        return script.html();
    }

    protected abstract String makeSummaryContent();

    protected void finishWritingOutput() throws IOException {
    }

    protected void close() {
    }

    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) {
        this.log = log;
        this.addStopLink(stopResponderId);
    }

    protected void publishAndAddLog() throws IOException {
        if (this.log != null) {
            this.log.publish(this.context.pageFactory);
            this.writeData(HtmlUtil.makeReplaceElementScript((String)"test-action", (String)this.executionStatus(this.log)).html());
        }
    }

    protected void maybeMakeErrorNavigatorVisible() {
        if (this.exceptionsOrErrorsExist()) {
            this.writeData(this.makeErrorNavigatorVisible());
            this.writeData(this.initErroMetadata());
        }
    }

    private boolean exceptionsOrErrorsExist() {
        return this.assertionCounts.getExceptions() + this.assertionCounts.getWrong() > 0;
    }

    public String executionStatus(CompositeExecutionLog log) {
        String errorLogPageName = log.getErrorLogPageName();
        if (log.exceptionCount() != 0) {
            return InteractiveFormatter.makeExecutionStatusLink((String)errorLogPageName, (ExecutionStatus)ExecutionStatus.ERROR);
        }
        if (log.hasCapturedOutput()) {
            return InteractiveFormatter.makeExecutionStatusLink((String)errorLogPageName, (ExecutionStatus)ExecutionStatus.OUTPUT);
        }
        return InteractiveFormatter.makeExecutionStatusLink((String)errorLogPageName, (ExecutionStatus)ExecutionStatus.OK);
    }

    private String makeErrorNavigatorVisible() {
        HtmlTag toggler = HtmlUtil.makeToggleClassScript((String)"error-nav", (String)"error-nav-hidden");
        return toggler.html();
    }

    private String initErroMetadata() {
        HtmlTag init = HtmlUtil.makeInitErrorMetadataScript();
        return init.html();
    }

    public static String makeExecutionStatusLink(String linkHref, ExecutionStatus executionStatus) {
        HtmlTag status = HtmlUtil.makeLink((String)linkHref, (String)executionStatus.getMessage());
        status.addAttribute("class", executionStatus.getStyle());
        return status.html();
    }
}

