/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.http.ChunkedResponse;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.responders.run.formatters.PageHistoryFormatter;
import fitnesse.responders.run.formatters.TestFormatterTest;
import fitnesse.responders.run.formatters.TestTextFormatter;
import fitnesse.responders.run.formatters.XmlFormatter;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import util.TimeMeasurement;

@RunWith(value=Parameterized.class)
public class TestFormatterTest {
    private BaseFormatter formatter;
    private TestPage page;
    private TestSummary right;
    private TestSummary wrong;
    private TestSummary exception;

    public TestFormatterTest(BaseFormatter formatter) {
        this.formatter = formatter;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> formatters() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        FitNesseContext context = FitNesseUtil.makeTestContext((WikiPage)root);
        ChunkedResponse response = (ChunkedResponse)Mockito.mock(ChunkedResponse.class);
        WikiPageDummy page = new WikiPageDummy("testPage", "testContent");
        XmlFormatter.WriterFactory writerFactory = (XmlFormatter.WriterFactory)Mockito.mock(XmlFormatter.WriterFactory.class);
        TestTextFormatter testTextFormatter = new TestTextFormatter(response);
        1 xmlFormatter = new /* Unavailable Anonymous Inner Class!! */;
        2 testHtmlFormatter = new /* Unavailable Anonymous Inner Class!! */;
        3 pageHistoryFormatter = new /* Unavailable Anonymous Inner Class!! */;
        return Arrays.asList({testTextFormatter}, {xmlFormatter}, {testHtmlFormatter}, {pageHistoryFormatter});
    }

    @Before
    public void setUp() throws Exception {
        this.page = new TestPage((WikiPage)new WikiPageDummy("page", "content"));
        this.right = new TestSummary(1, 0, 0, 0);
        this.wrong = new TestSummary(0, 1, 0, 0);
        this.exception = new TestSummary(0, 0, 0, 1);
    }

    @After
    public void clearStaticFields() {
        BaseFormatter.finalErrorCount = 0;
    }

    @Test
    public void testComplete_shouldCountTestResults() throws Exception {
        TimeMeasurement timeMeasurement = (TimeMeasurement)Mockito.mock(TimeMeasurement.class);
        Mockito.when((Object)timeMeasurement.startedAtDate()).thenReturn((Object)new Date(0L));
        Mockito.when((Object)timeMeasurement.elapsedSeconds()).thenReturn((Object)0.0);
        this.formatter.announceNumberTestsToRun(3);
        this.formatter.testComplete(this.page, this.right, timeMeasurement);
        this.formatter.testComplete(this.page, this.wrong, timeMeasurement);
        this.formatter.testComplete(this.page, this.exception, timeMeasurement);
        this.formatter.allTestingComplete(new TimeMeasurement().start().stop());
        Assert.assertEquals((long)3L, (long)this.formatter.testCount);
        Assert.assertEquals((long)2L, (long)this.formatter.failCount);
        if (!(this.formatter instanceof PageHistoryFormatter)) {
            Assert.assertEquals((long)2L, (long)BaseFormatter.finalErrorCount);
        }
    }
}

