/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.search.SearchFormResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

public class SearchFormResponderTest {
    private SimpleResponse response;
    private String content;
    private FitNesseContext context;

    @Before
    public void setUp() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        this.context = FitNesseUtil.makeTestContext((WikiPage)root);
        SearchFormResponder responder = new SearchFormResponder();
        this.response = (SimpleResponse)responder.makeResponse(this.context, (Request)new MockRequest());
        this.content = this.response.getContent();
    }

    public void testFocusOnSearchBox() throws Exception {
        RegexTestCase.assertSubString((String)"onload=\"document.forms[0].searchString.focus()\"", (String)this.content);
    }

    @Test
    public void testHtml() throws Exception {
        RegexTestCase.assertHasRegexp((String)"form", (String)this.content);
        RegexTestCase.assertHasRegexp((String)"input", (String)this.content);
        RegexTestCase.assertSubString((String)"<input", (String)this.content);
        RegexTestCase.assertSubString((String)"type=\"hidden\"", (String)this.content);
        RegexTestCase.assertSubString((String)"name=\"responder\"", (String)this.content);
        RegexTestCase.assertSubString((String)"value=\"search\"", (String)this.content);
    }

    @Test
    public void testForTwoSearchTypes() throws Exception {
        RegexTestCase.assertSubString((String)"type=\"submit\"", (String)this.content);
        RegexTestCase.assertSubString((String)"value=\"Search Titles\"", (String)this.content);
        RegexTestCase.assertSubString((String)"value=\"Search Content\"", (String)this.content);
    }

    @Test
    public void propertiesForm() throws Exception {
        RegexTestCase.assertHasRegexp((String)"<input.*value=\"Search Properties\".*>", (String)this.content);
        RegexTestCase.assertHasRegexp((String)"<input.*name=\"responder\".*value=\"executeSearchProperties\"", (String)this.content);
        for (String attributeName : SearchFormResponder.SEARCH_ACTION_ATTRIBUTES) {
            RegexTestCase.assertSubString((String)attributeName, (String)this.content);
        }
    }
}

