/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.templateUtilities;

import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PageTitle {
    private String title;
    private String link;
    private List<BreadCrumb> breadCrumbs = new ArrayList();
    private String pageType;
    private String pageTags;

    public PageTitle(WikiPagePath pagePath) {
        pagePath = pagePath.clone();
        List names = pagePath.getNames();
        this.link = PathParser.render((WikiPagePath)pagePath);
        if (names.size() > 0) {
            this.title = (String)names.get(names.size() - 1);
            pagePath.removeNameFromEnd();
            while (pagePath.getNames().size() > 0) {
                names = pagePath.getNames();
                BreadCrumb crumb = new BreadCrumb(this, (String)names.get(names.size() - 1), PathParser.render((WikiPagePath)pagePath));
                this.breadCrumbs.add(crumb);
                pagePath.removeNameFromEnd();
            }
            Collections.reverse(this.breadCrumbs);
        } else {
            this.title = "root";
        }
    }

    public PageTitle() {
    }

    public PageTitle(String pageType) {
        this.setPageType(pageType);
        this.title = pageType;
    }

    public PageTitle(String pageType, WikiPagePath wikiPagePath) {
        this(wikiPagePath);
        this.setPageType(pageType);
    }

    public PageTitle(String pageType, WikiPagePath wikiPagePath, String pageTags) {
        this(wikiPagePath);
        this.setPageType(pageType);
        this.setPageTags(pageTags);
    }

    public PageTitle(String path, String separator) {
        String crumb;
        String[] crumbs = path.split(separator);
        String trail = "";
        for (int i = 0; i < crumbs.length - 1; ++i) {
            crumb = crumbs[i];
            this.breadCrumbs.add(new BreadCrumb(this, crumb, trail + crumb));
            trail = trail + crumb + separator;
        }
        if (crumbs.length > 0) {
            this.title = crumb = crumbs[crumbs.length - 1];
            this.link = trail + crumb;
        }
    }

    public PageTitle(String pageType, String path, String separator) {
        this(path, separator);
        this.setPageType(pageType);
    }

    public PageTitle(String pageType, String path, String separator, String pageTags) {
        this(path, separator);
        this.setPageType(pageType);
        this.setPageTags(pageTags);
    }

    public PageTitle notLinked() {
        this.link = null;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLink() {
        return this.link;
    }

    public List<BreadCrumb> getBreadCrumbs() {
        return this.breadCrumbs;
    }

    public String getPageType() {
        return this.pageType;
    }

    public void setPageType(String pageType) {
        this.pageType = pageType;
    }

    public String getPageTags() {
        return this.pageTags;
    }

    public void setPageTags(String pageTags) {
        if (pageTags == null) {
            return;
        }
        if (pageTags == "") {
            return;
        }
        this.pageTags = pageTags;
    }
}

