/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.testHistory.HistoryComparer;
import fitnesse.responders.testHistory.HistoryComparerResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import java.io.File;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import util.FileUtil;
import util.RegexTestCase;

public class HistoryComparerResponderTest {
    public HistoryComparerResponder responder;
    public FitNesseContext context;
    public WikiPage root;
    public MockRequest request;
    public HistoryComparer mockedComparer;
    private final String FIRST_FILE_PATH = "./TestDir/files/testResults/TestFolder/firstFakeFile".replace('/', File.separatorChar);
    private final String SECOND_FILE_PATH = "./TestDir/files/testResults/TestFolder/secondFakeFile".replace('/', File.separatorChar);

    @Before
    public void setup() throws Exception {
        this.request = new MockRequest();
        this.mockedComparer = (HistoryComparer)Mockito.mock(HistoryComparer.class);
        this.responder = new HistoryComparerResponder(this.mockedComparer);
        this.responder.testing = true;
        HistoryComparer.resultContent = new ArrayList();
        HistoryComparer.resultContent.add("pass");
        Mockito.when((Object)this.mockedComparer.getResultContent()).thenReturn((Object)HistoryComparer.resultContent);
        Mockito.when((Object)this.mockedComparer.compare(this.FIRST_FILE_PATH, this.SECOND_FILE_PATH)).thenReturn((Object)true);
        this.mockedComparer.firstTableResults = new ArrayList();
        this.mockedComparer.secondTableResults = new ArrayList();
        this.mockedComparer.firstTableResults.add("<table><tr><td>This is the content</td></tr></table>");
        this.mockedComparer.secondTableResults.add("<table><tr><td>This is the content</td></tr></table>");
        this.request.addInput("TestResult_firstFakeFile", (Object)"");
        this.request.addInput("TestResult_secondFakeFile", (Object)"");
        this.request.setResource("TestFolder");
        FileUtil.createFile((String)"TestDir/files/testResults/TestFolder/firstFakeFile", (String)"firstFile");
        FileUtil.createFile((String)"TestDir/files/testResults/TestFolder/secondFakeFile", (String)"secondFile");
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.root = InMemoryPage.makeRoot((String)"RooT");
    }

    @Test
    public void shouldBeAbleToMakeASimpleResponse() throws Exception {
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void shouldGetTwoHistoryFilesFromRequest() throws Exception {
        this.responder.makeResponse(this.context, (Request)this.request);
        ((HistoryComparer)Mockito.verify((Object)this.mockedComparer)).compare(this.FIRST_FILE_PATH, this.SECOND_FILE_PATH);
    }

    @Test
    public void shouldReturnErrorPageIfCompareFails() throws Exception {
        Mockito.when((Object)this.mockedComparer.compare(this.FIRST_FILE_PATH, this.SECOND_FILE_PATH)).thenReturn((Object)false);
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        RegexTestCase.assertHasRegexp((String)"These files could not be compared.  They might be suites, or something else might be wrong.", (String)response.getContent());
    }

    @Test
    public void shouldReturnErrorPageIfFilesAreInvalid() throws Exception {
        this.request = new MockRequest();
        this.request.addInput("TestResult_firstFile", (Object)"");
        this.request.addInput("TestResult_secondFile", (Object)"");
        this.request.setResource("TestFolder");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        RegexTestCase.assertHasRegexp((String)"Compare Failed because the files were not found.", (String)response.getContent());
    }

    @Test
    public void shouldReturnErrorPageIfThereAreTooFewInputFiles() throws Exception {
        this.request = new MockRequest();
        this.request.addInput("TestResult_firstFile", (Object)"");
        this.request.setResource("TestFolder");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        RegexTestCase.assertHasRegexp((String)"Compare Failed because the wrong number of Input Files were given. Select two please.", (String)response.getContent());
    }

    @Test
    public void shouldReturnErrorPageIfThereAreTooManyInputFiles() throws Exception {
        this.request.addInput("TestResult_thirdFakeFile", (Object)"");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        RegexTestCase.assertHasRegexp((String)"Compare Failed because the wrong number of Input Files were given. Select two please.", (String)response.getContent());
    }

    @Test
    public void shouldReturnAResponseWithResultContent() throws Exception {
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        ((HistoryComparer)Mockito.verify((Object)this.mockedComparer)).getResultContent();
        RegexTestCase.assertHasRegexp((String)"This is the content", (String)response.getContent());
    }

    @After
    public void tearDown() {
        FileUtil.deleteFileSystemDirectory((String)"testRoot");
    }
}

