/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseVersion;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.responders.testHistory.PageHistory;
import fitnesse.responders.testHistory.PageHistoryResponder;
import fitnesse.responders.testHistory.TestHistory;
import fitnesse.testsystems.TestSummary;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SortedSet;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import util.DateTimeUtil;
import util.FileUtil;
import util.RegexTestCase;
import util.TimeMeasurement;

public class PageHistoryResponderTest {
    private File resultsDirectory;
    private TestHistory history;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private PageHistoryResponder responder;
    private SimpleResponse response;
    private MockRequest request;
    private FitNesseContext context;
    private FitNesseVersion fitNesseVersion = new FitNesseVersion();

    @Before
    public void setup() throws Exception {
        this.resultsDirectory = new File("testHistoryDirectory");
        this.removeResultsDirectory();
        this.resultsDirectory.mkdir();
        this.history = new TestHistory();
        this.responder = new PageHistoryResponder();
        this.responder.setResultsDirectory(this.resultsDirectory);
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        this.context = FitNesseUtil.makeTestContext((WikiPage)root);
    }

    @After
    public void teardown() {
        this.removeResultsDirectory();
    }

    private void makeResponse() throws Exception {
        this.request = new MockRequest();
        this.request.setResource("TestPage");
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        this.response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)root), (Request)this.request);
    }

    private void removeResultsDirectory() {
        if (this.resultsDirectory.exists()) {
            FileUtil.deleteFileSystemDirectory((File)this.resultsDirectory);
        }
    }

    private File addPageDirectory(String pageName) {
        File pageDirectory = new File(this.resultsDirectory, pageName);
        pageDirectory.mkdir();
        return pageDirectory;
    }

    private File addTestResult(File pageDirectory, String testResultFileName) throws IOException {
        File testResultFile = new File(pageDirectory, testResultFileName + ".xml");
        testResultFile.createNewFile();
        return testResultFile;
    }

    @Test
    public void shouldReportNoHistoryIfNoPageDirectory() throws Exception {
        this.makeResponse();
        RegexTestCase.assertHasRegexp((String)"No history for page: TestPage", (String)this.response.getContent());
    }

    @Test
    public void shouldReportNoHistoryIfNoHistoryInPageDirectory() throws Exception {
        this.addPageDirectory("TestPage");
        this.makeResponse();
        RegexTestCase.assertHasRegexp((String)"No history for page: TestPage", (String)this.response.getContent());
    }

    @Test
    public void pageHistoryShouldHaveStatsForOneTestIfOnePageHistoryFileIsPresent() throws Exception {
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addTestResult(pageDirectory, "20090418123103_1_2_3_4");
        this.history.readHistoryDirectory(this.resultsDirectory);
        PageHistory pageHistory = this.history.getPageHistory("TestPage");
        Assert.assertEquals((long)1L, (long)pageHistory.size());
        Assert.assertEquals((long)7L, (long)pageHistory.maxAssertions());
        SortedSet dates = pageHistory.datesInChronologicalOrder();
        Assert.assertEquals((long)1L, (long)dates.size());
        Date date = this.dateFormat.parse("20090418123103");
        Assert.assertEquals((Object)date, dates.first());
        PageHistory.PassFailBar passFailBar = pageHistory.getPassFailBar(date, 50);
        Assert.assertEquals((long)1L, (long)passFailBar.getPass());
        Assert.assertEquals((long)6L, (long)passFailBar.getFail());
        Assert.assertEquals((long)7L, (long)passFailBar.getPassUnits());
        Assert.assertEquals((long)43L, (long)passFailBar.getFailUnits());
    }

    @Test
    public void pageHistoryShouldHaveStatsForTwoTestsIfTwoPageHistoryFilesArePresent() throws Exception {
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addTestResult(pageDirectory, "20090503110451_6_5_3_1");
        this.addTestResult(pageDirectory, "20090418123103_1_2_3_4");
        this.history.readHistoryDirectory(this.resultsDirectory);
        PageHistory pageHistory = this.history.getPageHistory("TestPage");
        Assert.assertEquals((long)2L, (long)pageHistory.size());
        Assert.assertEquals((long)12L, (long)pageHistory.maxAssertions());
        SortedSet dates = pageHistory.datesInChronologicalOrder();
        Assert.assertEquals((long)2L, (long)dates.size());
        Date date1 = this.dateFormat.parse("20090418123103");
        Date date2 = this.dateFormat.parse("20090503110451");
        Date[] dateArray = dates.toArray(new Date[dates.size()]);
        Assert.assertEquals((Object)date1, (Object)dateArray[1]);
        Assert.assertEquals((Object)date2, (Object)dateArray[0]);
        PageHistory.PassFailBar passFailBar = pageHistory.getPassFailBar(date1, 50);
        Assert.assertEquals((long)1L, (long)passFailBar.getPass());
        Assert.assertEquals((long)6L, (long)passFailBar.getFail());
        Assert.assertEquals((long)4L, (long)passFailBar.getPassUnits());
        Assert.assertEquals((long)25L, (long)passFailBar.getFailUnits());
        passFailBar = pageHistory.getPassFailBar(date2, 50);
        Assert.assertEquals((long)6L, (long)passFailBar.getPass());
        Assert.assertEquals((long)6L, (long)passFailBar.getFail());
        Assert.assertEquals((long)25L, (long)passFailBar.getPassUnits());
        Assert.assertEquals((long)25L, (long)passFailBar.getFailUnits());
    }

    @Test
    public void evenOneFailureShouldCountInTheFailUnit() throws Exception {
        PageHistory.PassFailBar passFailBar = this.computePassFailBarFor(1000, 1, 0, 0);
        Assert.assertEquals((long)49L, (long)passFailBar.getPassUnits());
        Assert.assertEquals((long)1L, (long)passFailBar.getFailUnits());
    }

    @Test
    public void exactMultiplesShouldWork() throws Exception {
        PageHistory.PassFailBar passFailBar = this.computePassFailBarFor(48, 2, 0, 0);
        Assert.assertEquals((long)48L, (long)passFailBar.getPassUnits());
        Assert.assertEquals((long)2L, (long)passFailBar.getFailUnits());
    }

    @Test
    public void AllRedIfFractionOfOneUnitPasses() throws Exception {
        PageHistory.PassFailBar passFailBar = this.computePassFailBarFor(1, 1000, 0, 0);
        Assert.assertEquals((long)0L, (long)passFailBar.getPassUnits());
        Assert.assertEquals((long)50L, (long)passFailBar.getFailUnits());
    }

    private PageHistory.PassFailBar computePassFailBarFor(int right, int wrong, int ignores, int exceptions) throws IOException, ParseException {
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addTestResult(pageDirectory, String.format("20090503110451_%d_%d_%d_%d", right, wrong, ignores, exceptions));
        this.history.readHistoryDirectory(this.resultsDirectory);
        PageHistory pageHistory = this.history.getPageHistory("TestPage");
        Date date = this.dateFormat.parse("20090503110451");
        PageHistory.PassFailBar passFailBar = pageHistory.getPassFailBar(date, 50);
        return passFailBar;
    }

    @Test
    public void shouldNotReportNoHistoryIfHistoryIsPresent() throws Exception {
        this.addPageDirectory("TestPage");
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addTestResult(pageDirectory, "20090503110455_6_5_3_1");
        this.makeResponse();
        RegexTestCase.assertDoesntHaveRegexp((String)"No history for page: TestPage", (String)this.response.getContent());
    }

    @Test
    public void singlePassingResultShouldHaveTableandHeaderRow() throws Exception {
        this.addPageDirectory("TestPage");
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addTestResult(pageDirectory, "20090503110451_6_0_3_0");
        this.makeResponse();
        String content = this.response.getContent();
        content = content.replace("\n", " ");
        content = content.replace("\r", " ");
        RegexTestCase.assertHasRegexp((String)"<table>.*<tr>.*<th>Time</th>.*<th>Pass</th>.*<th>Fail</th>.*<th colspan=\"50\">0..6</th>.*<tr", (String)content);
        RegexTestCase.assertHasRegexp((String)"</tr>.*</table>", (String)content);
    }

    @Test
    public void singlePassingResultsShouldBeGreen() throws Exception {
        this.addPageDirectory("TestPage");
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addTestResult(pageDirectory, "20090503110451_6_0_3_0");
        this.makeResponse();
        RegexTestCase.assertHasRegexp((String)"<td .* class=\"pass\">.*03 May, 09 11:04.*</td>", (String)this.response.getContent());
    }

    @Test
    public void singleFailingResultsShouldBeRed() throws Exception {
        this.addPageDirectory("TestPage");
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addTestResult(pageDirectory, "20090503110451_6_1_3_0");
        this.makeResponse();
        RegexTestCase.assertHasRegexp((String)"<td .* class=\"fail\">.*03 May, 09 11:04.*</td>", (String)this.response.getContent());
    }

    @Test
    public void singleResultShouldShowPassFailStatistics() throws Exception {
        this.addPageDirectory("TestPage");
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addTestResult(pageDirectory, "20090503110451_6_1_3_1");
        this.makeResponse();
        RegexTestCase.assertHasRegexp((String)"<td .* class=\"fail\">2</td>", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"<td .* class=\"pass\">6</td>", (String)this.response.getContent());
    }

    @Test
    public void singleResultWithNoPassesOrFailuresShouldShowPassFailStatisticsInGrey() throws Exception {
        this.addPageDirectory("TestPage");
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addTestResult(pageDirectory, "20090503110451_0_0_3_0");
        this.makeResponse();
        RegexTestCase.assertHasRegexp((String)"<td .* class=\"ignore\">0</td>", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"<td .* class=\"ignore\">0</td>", (String)this.response.getContent());
    }

    @Test
    public void singleResultShouldShowPassFailBar() throws Exception {
        int i;
        this.addPageDirectory("TestPage");
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addTestResult(pageDirectory, "20090503110451_30_20_3_0");
        this.makeResponse();
        StringBuilder expected = new StringBuilder();
        for (i = 0; i < 30; ++i) {
            expected.append("<td id=\"element\" class=\"pass\">&nbsp</td>");
        }
        expected.append(".*");
        for (i = 0; i < 20; ++i) {
            expected.append("<td id=\"element\" class=\"fail\">&nbsp</td>");
        }
        RegexTestCase.assertHasRegexp((String)expected.toString(), (String)this.response.getContent());
    }

    @Test
    public void shortResultShouldShowPassFailBarWithPadding() throws Exception {
        int i;
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addTestResult(pageDirectory, "20090503110451_30_20_3_0");
        this.addTestResult(pageDirectory, "20090503143157_10_5_3_0");
        this.makeResponse();
        StringBuilder expected = new StringBuilder();
        for (i = 0; i < 10; ++i) {
            expected.append("<td id=\"element\" class=\"pass\">&nbsp</td>");
        }
        expected.append(".*");
        for (i = 0; i < 5; ++i) {
            expected.append("<td id=\"element\" class=\"fail\">&nbsp</td>");
        }
        expected.append(".*");
        for (i = 0; i < 35; ++i) {
            expected.append("<td id=\"element\" class=\"ignore\">&nbsp</td>");
        }
        RegexTestCase.assertHasRegexp((String)expected.toString(), (String)this.response.getContent());
    }

    @Test
    public void canGetTestExecutionReport() throws Exception {
        File pageDirectory = this.addPageDirectory("TestPage");
        File resultFile = new File(pageDirectory, "20090503110451_30_20_3_0.xml");
        this.addDummyTestResult(resultFile);
        this.makeResultForDate("TestPage", "20090503110451");
        RegexTestCase.assertHasRegexp((String)this.fitNesseVersion.toString(), (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"relativePageName", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"11 Right", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"22 Wrong", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"33 Ignores", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"44 Exceptions", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"99 ms", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"wad of HTML content", (String)this.response.getContent());
    }

    @Test
    public void canGetSuiteExecutionReport() throws Exception {
        File pageDirectory = this.addPageDirectory("SuitePage");
        File resultFile = new File(pageDirectory, "19801205012000_30_20_3_0.xml");
        this.addDummySuiteResult(resultFile);
        this.makeResultForDate("SuitePage", "19801205012000");
        RegexTestCase.assertSubString((String)this.fitNesseVersion.toString(), (String)this.response.getContent());
        RegexTestCase.assertSubString((String)"SuitePage.TestPageOne?pageHistory&resultDate=19801205012000", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"(12321 ms)", (String)this.response.getContent());
    }

    @Test
    public void canGetLatestWhenOnlyOneTestResultExists() throws Exception {
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addDummyTestResult(new File(pageDirectory, "19801205012000_30_20_3_0"));
        this.makeResultForDate("TestPage", "latest");
        RegexTestCase.assertHasRegexp((String)"Fri Dec 05 01:20:00 [A-Z]+ 1980", (String)this.response.getContent());
    }

    @Test
    public void canGetLatestWhenManyTestResultsExists() throws Exception {
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addDummyTestResult(new File(pageDirectory, "19801205012000_30_20_3_0"));
        this.addDummyTestResult(new File(pageDirectory, "19901205012000_30_20_3_0"));
        this.addDummyTestResult(new File(pageDirectory, "19951205012000_30_20_3_0"));
        this.addDummyTestResult(new File(pageDirectory, "19941205012000_30_20_3_0"));
        this.makeResultForDate("TestPage", "latest");
        RegexTestCase.assertHasRegexp((String)"Tue Dec 05 01:20:00 [A-Z]+ 1995", (String)this.response.getContent());
    }

    private void addDummySuiteResult(File resultFile) throws Exception {
        SuiteExecutionReport report = this.makeDummySuiteResponse();
        report.version = this.fitNesseVersion.toString();
        report.date = DateTimeUtil.getDateFromString((String)"12/5/1980 01:19:00");
        report.finalCounts = new TestSummary(4, 5, 6, 7);
        report.rootPath = "SuitePage";
        TimeMeasurement timeMeasurement = (TimeMeasurement)Mockito.mock(TimeMeasurement.class);
        Mockito.when((Object)timeMeasurement.elapsed()).thenReturn((Object)12321L);
        report.setTotalRunTimeInMillis(timeMeasurement);
        long time = DateTimeUtil.getTimeFromString((String)"12/5/1980 01:20:00");
        SuiteExecutionReport.PageHistoryReference r1 = new SuiteExecutionReport.PageHistoryReference("SuitePage.TestPageOne", time, 9L);
        SuiteExecutionReport.PageHistoryReference r2 = new SuiteExecutionReport.PageHistoryReference("SuitePage.TestPageTwo", time, 11L);
        r1.getTestSummary().right = 4;
        r2.getTestSummary().right = 4;
        report.addPageHistoryReference(r1);
        report.addPageHistoryReference(r2);
        this.generateSuiteResultFile(report, resultFile);
    }

    private void generateSuiteResultFile(SuiteExecutionReport report, File resultFile) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("suiteExecutionReport", (Object)report);
        Template template = this.context.pageFactory.getVelocityEngine().getTemplate("suiteHistoryXML.vm");
        FileWriter fileWriter = new FileWriter(resultFile);
        template.merge((Context)velocityContext, (Writer)fileWriter);
        fileWriter.close();
    }

    private SuiteExecutionReport makeDummySuiteResponse() {
        return new SuiteExecutionReport();
    }

    private void makeResultForDate(String page, String resultDate) throws Exception {
        this.request = new MockRequest();
        this.request.setResource(page);
        this.request.addInput("resultDate", (Object)resultDate);
        this.response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
    }

    private void addDummyTestResult(File resultFile) throws Exception {
        TestExecutionReport testResponse = this.makeDummyTestResponse();
        this.generateTestResultFile(testResponse, resultFile);
    }

    private void generateTestResultFile(TestExecutionReport testResponse, File resultFile) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("response", (Object)testResponse);
        Template template = this.context.pageFactory.getVelocityEngine().getTemplate("testResults.vm");
        FileWriter fileWriter = new FileWriter(resultFile);
        template.merge((Context)velocityContext, (Writer)fileWriter);
        fileWriter.close();
    }

    private TestExecutionReport makeDummyTestResponse() {
        TestExecutionReport testResponse = new TestExecutionReport();
        testResponse.version = this.fitNesseVersion.toString();
        testResponse.rootPath = "rootPath";
        testResponse.finalCounts = new TestSummary(1, 2, 3, 4);
        TestExecutionReport.TestResult result = new TestExecutionReport.TestResult();
        testResponse.results.add(result);
        result.right = "11";
        result.wrong = "22";
        result.ignores = "33";
        result.exceptions = "44";
        result.relativePageName = "relativePageName";
        result.content = "wad of HTML content";
        result.runTimeInMillis = "99";
        return testResponse;
    }

    @Test
    public void shouldStillGenerateReponseAndBarWhenThereIsAnInvalidFileNameInList() throws Exception {
        File pageDirectory = this.addPageDirectory("TestPage");
        this.addTestResult(pageDirectory, "bad_File_name");
        this.addTestResult(pageDirectory, "20090418123103_1_2_3_4");
        this.history.readHistoryDirectory(this.resultsDirectory);
        PageHistory pageHistory = this.history.getPageHistory("TestPage");
        Assert.assertEquals((long)1L, (long)pageHistory.size());
    }

    @Test
    public void shouldStillMakeResponseWithCorruptTestResultFile() throws Exception {
        File pageDirectory = this.addPageDirectory("TestPage");
        File resultFile = new File(pageDirectory, "20090503110451_30_20_3_0");
        this.addBadDummyTestResult(resultFile);
        this.makeResultForDate("TestPage", "20090503110451");
        RegexTestCase.assertHasRegexp((String)"Corrupt Test Result File", (String)this.response.getContent());
    }

    @Test
    public void shouldBeAbleToAcceptFormatIsXMLforARequest() throws Exception {
        this.request = new MockRequest();
        this.request.setResource("TestPage");
        this.request.addInput("format", (Object)"xml");
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        this.response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)root), (Request)this.request);
        Assert.assertEquals((Object)"text/xml", (Object)this.response.getContentType());
    }

    @Test
    public void shouldntBeCaseSensitiveForXMLRequest() throws Exception {
        this.request = new MockRequest();
        this.request.setResource("TestPage");
        this.request.addInput("format", (Object)"XMl");
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        this.response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)root), (Request)this.request);
        Assert.assertEquals((Object)"text/xml", (Object)this.response.getContentType());
    }

    @Test
    public void shouldSendTestExecutionReportInXMLUponRequest() throws Exception {
        this.request = new MockRequest();
        this.request.setResource("TestPage");
        File pageDirectory = this.addPageDirectory("TestPage");
        File resultFile = new File(pageDirectory, "20090503110451_30_20_3_0");
        this.addDummyTestResult(resultFile);
        this.request.addInput("resultDate", (Object)"20090503110451");
        this.request.addInput("format", (Object)"xml");
        this.response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        String content = this.response.getContent();
        RegexTestCase.assertHasRegexp((String)"<FitNesseVersion>", (String)content);
        Assert.assertEquals((Object)"text/xml", (Object)this.response.getContentType());
    }

    private void addBadDummyTestResult(File resultFile) throws Exception {
        FileUtil.createFile((File)resultFile, (String)"JUNK");
    }

    private TestExecutionReport makeBadDummyTestResponse() {
        TestExecutionReport testResponse = new TestExecutionReport();
        testResponse.version = "v1";
        testResponse.rootPath = "rootPath";
        testResponse.finalCounts = new TestSummary(1, 2, 3, 4);
        TestExecutionReport.TestResult result = new TestExecutionReport.TestResult();
        testResponse.results.add(result);
        result.right = "xx";
        result.wrong = "22";
        result.ignores = "33";
        result.exceptions = "44";
        result.relativePageName = "relativePageName";
        result.content = "wad of HTML content";
        return testResponse;
    }
}

