/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.testHistory.PageHistory;
import fitnesse.responders.testHistory.TestHistory;
import fitnesse.responders.testHistory.TestHistoryResponder;
import fitnesse.responders.testHistory.TestResultRecord;
import fitnesse.testsystems.TestSummary;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.FileUtil;
import util.RegexTestCase;

public class TestHistoryResponderTest {
    private File resultsDirectory;
    private TestHistory history;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private TestHistoryResponder responder;
    private SimpleResponse response;
    private FitNesseContext context;

    @Before
    public void setup() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        this.context = FitNesseUtil.makeTestContext((WikiPage)root);
        this.resultsDirectory = this.context.getTestHistoryDirectory();
        this.removeResultsDirectory();
        this.resultsDirectory.mkdirs();
        this.history = new TestHistory();
        this.responder = new TestHistoryResponder();
    }

    private void makeResponse() throws Exception {
        this.response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)new MockRequest());
    }

    private void removeResultsDirectory() {
        if (this.resultsDirectory.exists()) {
            FileUtil.deleteFileSystemDirectory((File)this.resultsDirectory);
        }
    }

    private void addPageDirectoryWithOneResult(String pageName, String testResultFileName) throws IOException {
        File pageDirectory = this.addPageDirectory(pageName);
        this.addTestResult(pageDirectory, testResultFileName);
    }

    private File addPageDirectory(String pageName) {
        File pageDirectory = new File(this.resultsDirectory, pageName);
        pageDirectory.mkdir();
        return pageDirectory;
    }

    @After
    public void teardown() {
        this.removeResultsDirectory();
    }

    @Test
    public void emptyHistoryDirectoryShouldShowNoPages() throws Exception {
        this.history.readHistoryDirectory(this.resultsDirectory);
        Assert.assertEquals((long)0L, (long)this.history.getPageNames().size());
    }

    @Test
    public void historyDirectoryWithOnePageDirectoryShouldShowOnePage() throws Exception {
        this.addPageDirectoryWithOneResult("SomePage", "20090418123103_1_2_3_4");
        this.history.readHistoryDirectory(this.resultsDirectory);
        Assert.assertEquals((long)1L, (long)this.history.getPageNames().size());
        Assert.assertTrue((boolean)this.history.getPageNames().contains("SomePage"));
    }

    @Test
    public void historyDirectoryWithOneEmptyPageDirectoryShouldShowNoPages() throws Exception {
        this.addPageDirectory("SomePage");
        this.history.readHistoryDirectory(this.resultsDirectory);
        Assert.assertEquals((long)0L, (long)this.history.getPageNames().size());
        Assert.assertFalse((boolean)this.history.getPageNames().contains("SomePage"));
    }

    @Test
    public void historyDirectoryWithTwoPageDirectoriesShouldShowTwoPages() throws Exception {
        this.addPageDirectoryWithOneResult("PageOne", "20090418123103_1_2_3_4");
        this.addPageDirectoryWithOneResult("PageTwo", "20090418123103_1_2_3_4");
        this.history.readHistoryDirectory(this.resultsDirectory);
        Assert.assertEquals((long)2L, (long)this.history.getPageNames().size());
        Assert.assertTrue((boolean)this.history.getPageNames().contains("PageOne"));
        Assert.assertTrue((boolean)this.history.getPageNames().contains("PageTwo"));
    }

    @Test
    public void historyDirectoryWithTwoEmptyPageDirectoriesShouldShowNoPages() throws Exception {
        this.addPageDirectory("SomePage");
        this.addPageDirectory("SomeOtherPage");
        this.history.readHistoryDirectory(this.resultsDirectory);
        Assert.assertEquals((long)0L, (long)this.history.getPageNames().size());
        Assert.assertFalse((boolean)this.history.getPageNames().contains("SomePage"));
        Assert.assertFalse((boolean)this.history.getPageNames().contains("SomeOtherPage"));
    }

    @Test
    public void testHistoryWithPageSelectedShouldShowPagesBelowSelectedPage() throws Exception {
        this.addPageDirectoryWithOneResult("ParentOne.PageOne", "20090418123103_1_2_3_4");
        this.addPageDirectoryWithOneResult("ParentOne.PageTwo", "20090418123103_1_2_3_4");
        this.addPageDirectoryWithOneResult("ParentTwo.PageThree", "20090418123103_1_2_3_4");
        this.history.readPageHistoryDirectory(this.resultsDirectory, "ParentOne");
        Set pageNames = this.history.getPageNames();
        Assert.assertEquals((long)2L, (long)pageNames.size());
        Assert.assertTrue((boolean)pageNames.contains("ParentOne.PageOne"));
        Assert.assertTrue((boolean)pageNames.contains("ParentOne.PageTwo"));
    }

    @Test
    public void pageDirectoryWithNoResultsShouldShowNoHistory() throws Exception {
        this.addPageDirectory("SomePage");
        this.history.readHistoryDirectory(this.resultsDirectory);
        PageHistory pageHistory = this.history.getPageHistory("SomePage");
        Assert.assertNull((Object)pageHistory);
    }

    @Test
    public void pageDirectoryWithOneResultShouldShowOneHistoryRecord() throws Exception {
        this.addPageDirectoryWithOneResult("SomePage", "20090418123103_1_2_3_4");
        this.history.readHistoryDirectory(this.resultsDirectory);
        PageHistory pageHistory = this.history.getPageHistory("SomePage");
        Assert.assertEquals((long)1L, (long)pageHistory.getFailures());
        Assert.assertEquals((long)0L, (long)pageHistory.getPasses());
        Date date = this.dateFormat.parse("20090418123103");
        Assert.assertEquals((Object)date, (Object)pageHistory.getMinDate());
        Assert.assertEquals((Object)date, (Object)pageHistory.getMaxDate());
        Assert.assertEquals((long)1L, (long)pageHistory.size());
        TestResultRecord testSummary = pageHistory.get(date);
        Assert.assertEquals((Object)date, (Object)testSummary.getDate());
        Assert.assertEquals((Object)new TestSummary(1, 2, 3, 4), (Object)testSummary);
    }

    private File addTestResult(File pageDirectory, String testResultFileName) throws IOException {
        File testResultFile = new File(pageDirectory, testResultFileName + ".xml");
        testResultFile.createNewFile();
        return testResultFile;
    }

    @Test
    public void pageDirectoryWithThreeResults() throws Exception {
        File pageDirectory = this.addPageDirectory("SomePage");
        this.addTestResult(pageDirectory, "20090418000000_1_0_0_0");
        this.addTestResult(pageDirectory, "20090419000000_1_1_0_0");
        this.addTestResult(pageDirectory, "20090417000000_1_0_0_1");
        this.history.readHistoryDirectory(this.resultsDirectory);
        PageHistory pageHistory = this.history.getPageHistory("SomePage");
        Assert.assertEquals((long)3L, (long)pageHistory.size());
        Assert.assertEquals((Object)this.dateFormat.parse("20090417000000"), (Object)pageHistory.getMinDate());
        Assert.assertEquals((Object)this.dateFormat.parse("20090419000000"), (Object)pageHistory.getMaxDate());
        Assert.assertEquals((long)1L, (long)pageHistory.getPasses());
        Assert.assertEquals((long)2L, (long)pageHistory.getFailures());
        Assert.assertEquals((Object)new TestSummary(1, 0, 0, 0), (Object)pageHistory.get(this.dateFormat.parse("20090418000000")));
        Assert.assertEquals((Object)new TestSummary(1, 1, 0, 0), (Object)pageHistory.get(this.dateFormat.parse("20090419000000")));
        Assert.assertEquals((Object)new TestSummary(1, 0, 0, 1), (Object)pageHistory.get(this.dateFormat.parse("20090417000000")));
    }

    @Test
    public void barGraphWithOnePassingResultShouldBeSingleTrueBoolean() throws Exception {
        PageHistory.BarGraph barGraph = this.makeBarGraph(new String[]{"20090418123103_1_0_0_0"});
        Assert.assertEquals((long)1L, (long)barGraph.size());
        Assert.assertTrue((boolean)barGraph.getPassFail(0).isPass());
    }

    private PageHistory.BarGraph makeBarGraph(String[] testResultFilenames) throws IOException {
        File pageDirectory = this.addPageDirectory("SomePage");
        for (String fileName : testResultFilenames) {
            this.addTestResult(pageDirectory, fileName);
        }
        this.history.readHistoryDirectory(this.resultsDirectory);
        PageHistory pageHistory = this.history.getPageHistory("SomePage");
        PageHistory.BarGraph barGraph = pageHistory.getBarGraph();
        return barGraph;
    }

    @Test
    public void barGraphWithOneFailingResultShouldBeSingleFalseBoolean() throws Exception {
        PageHistory.BarGraph barGraph = this.makeBarGraph(new String[]{"20090418123103_0_1_0_0"});
        Assert.assertEquals((long)1L, (long)barGraph.size());
        Assert.assertFalse((boolean)barGraph.getPassFail(0).isPass());
    }

    private PageHistory.BarGraph makeBarGraphWithManyResults() throws IOException {
        PageHistory.BarGraph barGraph = this.makeBarGraph(new String[]{"20090418123103_0_0_0_0", "20090419123104_1_0_0_0", "20090420123105_0_1_0_0", "20090421123106_0_0_1_0", "20090422123107_0_0_0_1", "20090423123108_1_1_0_0", "20090424123109_1_0_1_0", "20090425123110_1_0_0_1"});
        return barGraph;
    }

    @Test
    public void barGraphWithManyResultsShouldHaveCorrespondingBooleans() throws Exception {
        PageHistory.BarGraph barGraph = this.makeBarGraphWithManyResults();
        Assert.assertEquals((Object)"-+----+-", (Object)barGraph.testString());
    }

    @Test
    public void barGraphWithOneResultShouldHaveSameStartingAndEndingDate() throws Exception {
        PageHistory.BarGraph barGraph = this.makeBarGraph(new String[]{"20090418123103_1_0_0_0"});
        Assert.assertEquals((Object)this.dateFormat.parse("20090418123103"), (Object)barGraph.getStartingDate());
        Assert.assertEquals((Object)this.dateFormat.parse("20090418123103"), (Object)barGraph.getEndingDate());
    }

    @Test
    public void barGraphWithManyResultsShouldHaveStartingAndEndingDateCorrect() throws Exception {
        PageHistory.BarGraph barGraph = this.makeBarGraphWithManyResults();
        Assert.assertEquals((Object)this.dateFormat.parse("20090418123103"), (Object)barGraph.getStartingDate());
        Assert.assertEquals((Object)this.dateFormat.parse("20090425123110"), (Object)barGraph.getEndingDate());
    }

    @Test
    public void BarGraphResultsAreInReverseChronologicalOrder() throws Exception {
        String apr17Fail = "20090417123103_0_1_0_0";
        String apr18Pass = "20090418123103_1_0_0_0";
        PageHistory.BarGraph barGraph = this.makeBarGraph(new String[]{apr17Fail, apr18Pass});
        Assert.assertEquals((Object)"+-", (Object)barGraph.testString());
    }

    @Test
    public void barGraphLimitedToLast20Results() throws Exception {
        ArrayList<String> dates = new ArrayList<String>();
        for (int day = 1; day < 32; ++day) {
            int right = day == 31 ? 1 : 0;
            dates.add(String.format("200905%02d010203_%1d_0_0_0", day, right));
        }
        PageHistory.BarGraph barGraph = this.makeBarGraph(dates.toArray(new String[dates.size()]));
        Assert.assertEquals((long)20L, (long)barGraph.size());
        Assert.assertEquals((Object)this.dateFormat.parse("20090512010203"), (Object)barGraph.getStartingDate());
        Assert.assertEquals((Object)this.dateFormat.parse("20090531010203"), (Object)barGraph.getEndingDate());
        Assert.assertEquals((Object)"+-------------------", (Object)barGraph.testString());
    }

    @Test
    public void responseWithNoHistoryShouldSayNoHistory() throws Exception {
        this.makeResponse();
        RegexTestCase.assertHasRegexp((String)"No History", (String)this.response.getContent());
    }

    @Test
    public void whenPageDirectoriesHaveNoResultsResponseShouldSayNoHistory() throws Exception {
        this.addPageDirectory("SomePage");
        this.makeResponse();
        RegexTestCase.assertHasRegexp((String)"No History", (String)this.response.getContent());
    }

    @Test
    public void testHistoryFormatMatchesRegularExpression() throws Exception {
        Assert.assertTrue((boolean)PageHistory.matchesPageHistoryFileFormat((String)"20090513134559_01_02_03_04.xml"));
    }

    @Test
    public void whenPageDirectoryHasResultsRepsonseShouldShowSummary() throws Exception {
        File pageDirectory = this.addPageDirectory("SomePage");
        this.addTestResult(pageDirectory, "20090418123103_1_2_3_4");
        this.addTestResult(pageDirectory, "20090419123103_1_0_0_0");
        this.makeResponse();
        RegexTestCase.assertHasRegexp((String)"SomePage", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"<td class=\"pass\">1</td>", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"<td class=\"fail\">1</td>", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"<td>19 Apr 09, 12:31</td>", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"<td class=\"pass\">.*\\+.*</td>", (String)this.response.getContent());
        RegexTestCase.assertHasRegexp((String)"<td class=\"fail\">.*-.*</td>", (String)this.response.getContent());
        RegexTestCase.assertDoesntHaveRegexp((String)"No History", (String)this.response.getContent());
    }

    @Test
    public void shouldNotCountABadDirectoryNameAsAHistoryDirectory() throws Exception {
        this.addPageDirectoryWithOneResult("SomePage", "20090419123103_1_0_0_0");
        this.addPageDirectoryWithOneResult("bad-directory-name", "20090419123103_1_0_0_0");
        this.history.readHistoryDirectory(this.resultsDirectory);
        Assert.assertEquals((long)1L, (long)this.history.getPageNames().size());
        Assert.assertTrue((boolean)this.history.getPageNames().contains("SomePage"));
    }

    @Test
    public void shouldGenerateHistoryEvenWithBadFileNames() throws Exception {
        File pageDirectory = this.addPageDirectory("SomePage");
        this.addTestResult(pageDirectory, "20090602000000_1_0_0_0");
        this.addTestResult(pageDirectory, "20090603000000_12_1_0_0");
        this.addTestResult(pageDirectory, "20090604000000_1_0_125_0");
        this.addTestResult(pageDirectory, "2009060200000012_1_0_0_0");
        this.addTestResult(pageDirectory, "20090602000000_1_0_0_0_0_0");
        this.addTestResult(pageDirectory, "bad_file_page_thing");
        this.makeResponse();
        this.history.readHistoryDirectory(this.resultsDirectory);
        PageHistory pageHistory = this.history.getPageHistory("SomePage");
        Assert.assertEquals((long)3L, (long)pageHistory.size());
    }

    @Test
    public void shouldBeAbleToAcceptFormatIsXMLforARequest() throws Exception {
        MockRequest request = new MockRequest();
        request.addInput("format", (Object)"xml");
        this.response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)request);
        RegexTestCase.assertHasRegexp((String)"text/xml", (String)this.response.getContentType());
    }

    @Test
    public void shouldntBeCaseSensitiveForXMLRequest() throws Exception {
        MockRequest request = new MockRequest();
        request.addInput("format", (Object)"xML");
        this.response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)request);
        RegexTestCase.assertHasRegexp((String)"text/xml", (String)this.response.getContentType());
    }
}

