/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.versions;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.versions.VersionComparer;
import fitnesse.responders.versions.VersionComparerResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import util.RegexTestCase;

public class VersionComparerResponderTest {
    private String firstVersion;
    private String secondVersion;
    private SimpleResponse response;
    private WikiPage root;
    private WikiPage page;
    private VersionComparerResponder responder;
    private MockRequest request;
    private FitNesseContext context;
    private VersionComparer mockedComparer;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.page = this.root.getPageCrawler().addPage(this.root, PathParser.parse((String)"ComparedPage"), "original content");
        PageData data = this.page.getData();
        WikiPageProperties properties = data.getProperties();
        properties.set("Suites", "New Page tags");
        data = this.page.getData();
        data.setContent("new stuff");
        this.firstVersion = this.page.commit(data).getName();
        data = this.page.getData();
        data.setContent("even newer stuff");
        this.secondVersion = this.page.commit(data).getName();
        this.request = new MockRequest();
        this.request.setResource("ComparedPage");
        this.mockedComparer = (VersionComparer)Mockito.mock(VersionComparer.class);
        this.responder = new VersionComparerResponder(this.mockedComparer);
        this.responder.testing = true;
    }

    @Test
    public void shouldCompareTheTwoVersionsSpecified() throws Exception {
        this.request.addInput("Version_" + this.firstVersion, (Object)"");
        this.request.addInput("Version_" + this.secondVersion, (Object)"");
        Mockito.when((Object)this.mockedComparer.compare(this.firstVersion, "original content", this.secondVersion, "new stuff")).thenReturn((Object)true);
        this.response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)200L, (long)this.response.getStatus());
        ((VersionComparer)Mockito.verify((Object)this.mockedComparer)).compare(this.firstVersion, "original content", this.secondVersion, "new stuff");
    }

    @Test
    public void shouldCompareTheOneVersionSpecifiedToTheCurrentVersion() throws Exception {
        this.request.addInput("Version_" + this.secondVersion, (Object)"");
        Mockito.when((Object)this.mockedComparer.compare(this.secondVersion, "new stuff", "latest", "even newer stuff")).thenReturn((Object)true);
        this.response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)200L, (long)this.response.getStatus());
        ((VersionComparer)Mockito.verify((Object)this.mockedComparer)).compare(this.secondVersion, "new stuff", "latest", "even newer stuff");
    }

    @Test
    public void shouldReturnErrorResponseIfNoVersionsSpecified() throws Exception {
        this.response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)400L, (long)this.response.getStatus());
        RegexTestCase.assertHasRegexp((String)"Compare Failed because no Input Files were given. Select one or two please.", (String)this.response.getContent());
    }
}

