/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.versions;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.responders.versions.VersionResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VersionResponder
implements SecureResponder {
    private String version;
    private String resource;

    public Response makeResponse(FitNesseContext context, Request request) {
        WikiPagePath path;
        this.resource = request.getResource();
        this.version = (String)request.getInput("version");
        if (this.version == null) {
            return new ErrorResponder("No version specified.").makeResponse(context, request);
        }
        PageCrawler pageCrawler = context.root.getPageCrawler();
        WikiPage page = pageCrawler.getPage(context.root, path = PathParser.parse((String)this.resource));
        if (page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        String fullPathName = PathParser.render((WikiPagePath)pageCrawler.getFullPath(page));
        HtmlPage html = this.makeHtml(fullPathName, page, context);
        SimpleResponse response = new SimpleResponse();
        response.setContent(html.html());
        return response;
    }

    private HtmlPage makeHtml(String name, WikiPage page, FitNesseContext context) {
        PageData pageData = page.getDataVersion(this.version);
        HtmlPage html = context.pageFactory.newPage();
        html.setTitle("Version " + this.version + ": " + name);
        html.setPageTitle(new PageTitle("Version " + this.version, PathParser.parse((String)this.resource), pageData.getAttribute("Suites")));
        html.setNavTemplate("versionNav.vm");
        html.put("rollbackVersion", (Object)this.version);
        html.put("localPath", (Object)name);
        ArrayList versions = new ArrayList(page.getData().getVersions());
        Collections.sort(versions);
        Collections.reverse(versions);
        String nextVersion = this.selectNextVersion(versions, this.version);
        html.put("nextVersion", (Object)nextVersion);
        String previousVersion = this.selectPreviousVersion(versions, this.version);
        html.put("previousVersion", (Object)previousVersion);
        html.setMainTemplate("wikiPage");
        html.put("content", (Object)new VersionRenderer(this, pageData));
        return html;
    }

    private String selectPreviousVersion(List<VersionInfo> versions, String current) {
        int i = 0;
        for (i = 0; i < versions.size() && !versions.get(i).getName().equals(current); ++i) {
        }
        if (i < 0 || i > versions.size() - 2) {
            return null;
        }
        return versions.get(i + 1).getName();
    }

    private String selectNextVersion(List<VersionInfo> versions, String current) {
        int i;
        for (i = 0; i < versions.size() && !versions.get(i).getName().equals(current); ++i) {
        }
        if (i < 1 || i > versions.size()) {
            return null;
        }
        return versions.get(i - 1).getName();
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

