/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.versions;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.versions.VersionResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class VersionResponderTest
extends RegexTestCase {
    private String oldVersion;
    private SimpleResponse response;
    private WikiPage root;
    private WikiPage page;

    private void makeTestResponse(String pageName) throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        FitNesseContext context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.page = this.root.getPageCrawler().addPage(this.root, PathParser.parse((String)pageName), "original content");
        PageData data = this.page.getData();
        WikiPageProperties properties = data.getProperties();
        properties.set("Suites", "New Page tags");
        data.setContent("new stuff");
        VersionInfo commitRecord = this.page.commit(data);
        this.oldVersion = commitRecord.getName();
        MockRequest request = new MockRequest();
        request.setResource(pageName);
        request.addInput("version", (Object)this.oldVersion);
        VersionResponder responder = new VersionResponder();
        this.response = (SimpleResponse)responder.makeResponse(context, (Request)request);
    }

    public void testVersionName() throws Exception {
        this.makeTestResponse("PageOne");
        VersionResponderTest.assertHasRegexp((String)"original content", (String)this.response.getContent());
        VersionResponderTest.assertDoesntHaveRegexp((String)"new stuff", (String)this.response.getContent());
        VersionResponderTest.assertHasRegexp((String)this.oldVersion, (String)this.response.getContent());
        VersionResponderTest.assertNotSubString((String)"New Page tags", (String)this.response.getContent());
    }

    public void testButtons() throws Exception {
        this.makeTestResponse("PageOne");
        VersionResponderTest.assertDoesntHaveRegexp((String)"Edit button", (String)this.response.getContent());
        VersionResponderTest.assertDoesntHaveRegexp((String)"Search button", (String)this.response.getContent());
        VersionResponderTest.assertDoesntHaveRegexp((String)"Test button", (String)this.response.getContent());
        VersionResponderTest.assertDoesntHaveRegexp((String)"Suite button", (String)this.response.getContent());
        VersionResponderTest.assertDoesntHaveRegexp((String)"Versions button", (String)this.response.getContent());
        VersionResponderTest.assertHasRegexp((String)">Rollback</a>", (String)this.response.getContent());
    }

    public void testNameNoAtRootLevel() throws Exception {
        this.makeTestResponse("PageOne.PageTwo");
        VersionResponderTest.assertSubString((String)"PageOne.PageTwo?responder=", (String)this.response.getContent());
    }
}

