/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fitnesse.FitNesseContext;
import fitnesse.components.ContentBuffer;
import fitnesse.responders.PageFactory;
import fitnesse.responders.run.formatters.SuiteHtmlFormatter;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.runner.HtmlResultFormatter;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultFormatter;
import fitnesse.testsystems.TestSummary;
import fitnesse.wiki.PathParser;
import java.io.IOException;
import java.io.InputStream;

public class HtmlResultFormatter
implements ResultFormatter {
    private ContentBuffer buffer;
    private boolean closed = false;
    private SuiteHtmlFormatter suiteFormatter;
    private FitNesseContext context;
    private String host;
    private String rootPath;
    private HtmlPage htmlPage;

    public HtmlResultFormatter(FitNesseContext context, String host, String rootPath) throws IOException {
        this.context = context;
        this.host = host;
        this.rootPath = rootPath;
        this.buffer = new ContentBuffer(".html");
        this.createPage(context.pageFactory, rootPath);
        this.suiteFormatter = this.createCustomFormatter();
        System.out.println("Built HtmlResultFormatter for " + rootPath);
    }

    private SuiteHtmlFormatter createCustomFormatter() {
        1 formatter = new /* Unavailable Anonymous Inner Class!! */;
        return formatter;
    }

    private void createPage(PageFactory pageFactory, String rootPath) {
        this.htmlPage = this.context.pageFactory.newPage();
        this.htmlPage.setTitle(rootPath);
        this.htmlPage.put("baseUri", (Object)this.baseUri(this.host));
        this.htmlPage.setPageTitle(new PageTitle("Command Line Test Results", PathParser.parse((String)rootPath)));
    }

    public String baseUri(String host) {
        StringBuffer href = new StringBuffer("http://");
        href.append(host);
        href.append("/");
        return href.toString();
    }

    public void acceptResult(PageResult result) throws IOException {
        String relativePageName = result.title();
        this.suiteFormatter.announceStartNewTest(relativePageName, this.rootPath + "." + relativePageName);
        this.suiteFormatter.testOutputChunk(result.content());
        this.suiteFormatter.processTestResults(relativePageName, result.testSummary());
    }

    public void acceptFinalCount(TestSummary testSummary) throws IOException {
        this.suiteFormatter.testSummary();
        this.suiteFormatter.finishWritingOutput();
    }

    private void close() throws IOException {
        if (!this.closed) {
            this.suiteFormatter.finishWritingOutput();
            this.closed = true;
        }
    }

    public int getByteCount() throws IOException {
        this.close();
        return this.buffer.getSize();
    }

    public InputStream getResultStream() throws IOException {
        this.close();
        return this.buffer.getInputStream();
    }

    static /* synthetic */ ContentBuffer access$000(HtmlResultFormatter x0) {
        return x0.buffer;
    }
}

