/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.ListExecutor;
import fitnesse.slim.NameTranslator;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.StatementExecutorInterface;
import java.util.List;
import util.ListUtility;

public class ListExecutor {
    private StatementExecutorInterface executor;
    private NameTranslator methodNameTranslator;
    private boolean verbose;

    public ListExecutor(SlimFactory slimFactory) {
        this(false, slimFactory);
    }

    protected ListExecutor(boolean verbose, SlimFactory slimFactory) {
        this.verbose = verbose;
        this.executor = slimFactory.getStatementExecutor();
        this.methodNameTranslator = slimFactory.getMethodNameTranslator();
    }

    protected void setVerbose() {
        this.verbose = true;
    }

    public List<Object> execute(List<Object> statements) {
        LoggingExecutive e = this.verbose ? new LoggingExecutive(this, null) : new Executive(this, null);
        e.prepareToExecute();
        List result = e.executeStatements(statements);
        e.finalizeExecution();
        return result;
    }

    private List<Object> asStatementList(Object statement) {
        return ListUtility.uncheckedCast(Object.class, (Object)statement);
    }

    private void verboseMessage(Object message) {
        if (this.verbose) {
            System.out.println(message);
        }
    }

    static /* synthetic */ StatementExecutorInterface access$000(ListExecutor x0) {
        return x0.executor;
    }

    static /* synthetic */ List access$100(ListExecutor x0, Object x1) {
        return x0.asStatementList(x1);
    }

    static /* synthetic */ NameTranslator access$200(ListExecutor x0) {
        return x0.methodNameTranslator;
    }

    static /* synthetic */ void access$400(ListExecutor x0, Object x1) {
        x0.verboseMessage(x1);
    }
}

