/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.SlimHelperLibrary;
import fitnesse.slim.StatementExecutor;
import fitnesse.slim.StatementExecutorInterface;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SlimHelperLibraryTest {
    private static final String SLIM_HELPER_LIBRARY_INSTANCE_NAME = "SlimHelperLibrary";
    private static final String ACTOR_INSTANCE_NAME = "scriptTableActor";
    private StatementExecutorInterface caller;

    private String getTestClassName() {
        return "fitnesse.slim.test.TestSlim";
    }

    @Before
    public void setUp() throws Exception {
        this.caller = new StatementExecutor();
    }

    @Test
    public void testSlimHelperLibraryIsStoredInSlimExecutor() throws Exception {
        Object helperLibrary = this.caller.getInstance(SLIM_HELPER_LIBRARY_INSTANCE_NAME);
        Assert.assertTrue((boolean)(helperLibrary instanceof SlimHelperLibrary));
    }

    @Test
    public void testSlimHelperLibraryHasStatementExecutor() throws Exception {
        SlimHelperLibrary helperLibrary = (SlimHelperLibrary)this.caller.getInstance(SLIM_HELPER_LIBRARY_INSTANCE_NAME);
        Assert.assertSame((Object)this.caller, (Object)helperLibrary.getStatementExecutor());
    }

    @Test
    public void testSlimHelperLibraryCanPushAndPopFixture() throws Exception {
        SlimHelperLibrary helperLibrary = (SlimHelperLibrary)this.caller.getInstance(SLIM_HELPER_LIBRARY_INSTANCE_NAME);
        this.caller.create(ACTOR_INSTANCE_NAME, this.getTestClassName(), new Object[0]);
        Object firstActor = this.caller.getInstance(ACTOR_INSTANCE_NAME);
        helperLibrary.pushFixture();
        this.caller.create(ACTOR_INSTANCE_NAME, this.getTestClassName(), new Object[]{"1"});
        Assert.assertNotSame((Object)firstActor, (Object)this.caller.getInstance(ACTOR_INSTANCE_NAME));
        helperLibrary.popFixture();
        Assert.assertSame((Object)firstActor, (Object)this.caller.getInstance(ACTOR_INSTANCE_NAME));
    }
}

