/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.JavaSlimFactory;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.SlimServer;
import fitnesse.slim.fixtureInteraction.DefaultInteraction;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import util.CommandLine;

/*
 * Exception performing whole class analysis ignored.
 */
public class SlimService {
    static boolean verbose;
    static int port;
    static String interactionClassName;
    private final ServerSocket serverSocket;
    private final SlimServer slimServer;
    static Thread service;

    public static void main(String[] args) throws IOException {
        if (SlimService.parseCommandLine((String[])args)) {
            SlimService.startWithFactory((SlimFactory)new JavaSlimFactory());
        } else {
            SlimService.parseCommandLineFailed((String[])args);
        }
    }

    protected static void parseCommandLineFailed(String[] args) {
        System.err.println("Invalid command line arguments:" + Arrays.asList(args));
    }

    public static void startWithFactory(SlimFactory slimFactory) throws IOException {
        SlimService slimservice = new SlimService(slimFactory.getSlimServer(verbose));
        slimservice.accept();
    }

    public static void startWithFactoryAsync(SlimFactory slimFactory) throws IOException {
        if (service != null && service.isAlive()) {
            System.err.println("Already an in-process server running: " + service.getName() + " (alive=" + service.isAlive() + ")");
            service.interrupt();
            throw new RuntimeException("Already an in-process server running: " + service.getName() + " (alive=" + service.isAlive() + ")");
        }
        SlimService slimservice = new SlimService(slimFactory.getSlimServer(verbose));
        service = new /* Unavailable Anonymous Inner Class!! */;
        service.start();
    }

    public static void waitForServiceToStopAsync() throws InterruptedException {
        for (int i = 0; i < 1000 && service.isAlive(); ++i) {
            Thread.sleep(50L);
        }
    }

    public static boolean parseCommandLine(String[] args) {
        CommandLine commandLine = new CommandLine("[-v] [-i interactionClass] port ");
        if (commandLine.parse(args)) {
            verbose = commandLine.hasOption("v");
            interactionClassName = commandLine.getOptionArgument("i", "interactionClass");
            String portString = commandLine.getArgument("port");
            port = portString == null ? 8099 : Integer.parseInt(portString);
            return true;
        }
        return false;
    }

    public SlimService(SlimServer slimServer) throws IOException {
        this.slimServer = slimServer;
        try {
            this.serverSocket = this.tryCreateServerSocket(port);
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of Memory. Aborting");
            e.printStackTrace();
            System.exit(99);
            throw e;
        }
    }

    private ServerSocket tryCreateServerSocket(int port) throws IOException {
        try {
            return new ServerSocket(port);
        }
        catch (IOException e) {
            System.out.println("IO exception on port = " + port);
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept() throws IOException {
        Socket socket = null;
        try {
            socket = this.serverSocket.accept();
            this.slimServer.serve(socket);
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of Memory. Aborting");
            e.printStackTrace();
            System.exit(99);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
            this.serverSocket.close();
        }
    }

    public static Class<DefaultInteraction> getInteractionClass() {
        if (interactionClassName == null) {
            return DefaultInteraction.class;
        }
        try {
            return Class.forName(interactionClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        interactionClassName = null;
    }
}

