/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.StackTraceEnricher;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StackTraceEnricherTest {
    private static final String JUNIT_JAR_PATTERN = "[junit";
    private static final String RT_JAR = "rt.jar";
    private static final String NON_EXISTING_FILE = "/this/should/not/exist/at/all/sadfbas";
    private Throwable exception;
    private String javaVersion;
    private StackTraceEnricher enricher;

    @Before
    public void setUp() {
        this.exception = this.createIoException();
        this.javaVersion = this.getJavaVersion();
        this.enricher = new StackTraceEnricher();
    }

    private Throwable createIoException() {
        IOException exception = null;
        try {
            new FileInputStream(new File(NON_EXISTING_FILE));
            Assert.fail((String)"Managed to find a file that shouldn't exist /this/should/not/exist/at/all/sadfbas");
        }
        catch (IOException ioe) {
            if (ioe.getStackTrace() == null || ioe.getStackTrace().length == 0) {
                ioe.fillInStackTrace();
            }
            exception = ioe;
        }
        return exception;
    }

    private String getJavaVersion() {
        String fullVersion = System.getProperty("java.runtime.version", "Failed to read Java RT version");
        String version = fullVersion.contains("-") ? fullVersion.substring(0, fullVersion.indexOf(45)) : fullVersion;
        return version;
    }

    private StackTraceElement getJavaLangStackTraceElement(Throwable exception) {
        StackTraceElement javaLangElement = null;
        for (StackTraceElement element : exception.getStackTrace()) {
            if (!element.getClassName().startsWith("java.lang")) continue;
            javaLangElement = element;
            break;
        }
        if (javaLangElement == null) {
            Assert.fail((String)"Unable to find a java.lang class in the stack trace.");
        }
        return javaLangElement;
    }

    @Test
    public void shouldWriteEnrichedStackTraceToWriter() throws Exception {
        StringWriter writer = new StringWriter();
        this.enricher.printStackTrace(this.exception, (Writer)writer);
        Assert.assertTrue((String)"JUnit jar [junit not found in stack trace written to writer", (boolean)writer.toString().contains(JUNIT_JAR_PATTERN));
    }

    @Test
    public void shouldWriteEnrichedStackTraceToOutputStream() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.enricher.printStackTrace(this.exception, (OutputStream)outputStream);
        String output = new String(outputStream.toByteArray());
        Assert.assertTrue((String)"JUnit jar [junit not found in stack trace written to output stream", (boolean)output.contains(JUNIT_JAR_PATTERN));
    }

    @Test
    public void shouldReturnEnrichedStackTraceAsString() {
        Assert.assertTrue((String)"JUnit jar [junit not found in stack trace as String", (boolean)this.enricher.getStackTraceAsString(this.exception).contains(JUNIT_JAR_PATTERN));
    }

    @Test
    public void shouldParseRtJar() {
        Assert.assertTrue((String)"Java RT jar not properly determined.", (boolean)this.enricher.getStackTraceAsString(this.exception).contains(RT_JAR));
    }

    @Test
    public void shouldAddVersionWhenAvailable() {
        Assert.assertTrue((String)"Version not added for rt.jar", (boolean)this.enricher.getStackTraceAsString(this.exception).contains("rt.jar:" + this.javaVersion));
    }

    @Test
    public void shouldGetVersionForClassInJarWithVersion() {
        Assert.assertTrue((String)"Version not retrieved for java.lang.reflect.Method", (boolean)this.enricher.getVersion(Method.class).contains(this.javaVersion));
    }

    @Test
    public void shouldGetVersionForStackTraceElementInJarWithVersion() {
        StackTraceElement javaLangElement = this.getJavaLangStackTraceElement(this.exception);
        Assert.assertTrue((String)("Version not retrieved for " + javaLangElement.getClassName()), (boolean)this.enricher.getVersion(javaLangElement).contains(this.javaVersion));
    }

    @Test
    public void shouldGetLocationForClassInJarWithVersion() {
        Assert.assertEquals((String)"Location not retrieved for java.lang.reflect.Method", (Object)this.enricher.getLocation(Method.class), (Object)RT_JAR);
    }

    @Test
    public void shouldGetLocationForStackTraceElementInJarWithVersion() {
        StackTraceElement javaLangElement = this.getJavaLangStackTraceElement(this.exception);
        Assert.assertEquals((String)("Version not retrieved for " + javaLangElement.getClassName()), (Object)this.enricher.getLocation(javaLangElement), (Object)RT_JAR);
    }

    @Test
    public void shouldParseDirectories() {
        String classPath = System.getProperty("java.class.path");
        classPath = classPath.replace('\\', '/');
        String testLocation = this.enricher.getLocation(this.getClass());
        if (!testLocation.contains(".jar")) {
            if ((testLocation = testLocation.replace('\\', '/')).startsWith("file:/")) {
                testLocation = testLocation.substring("file:/".length());
            }
            if (testLocation.endsWith("/")) {
                testLocation = testLocation.substring(0, testLocation.length() - 1);
            }
            Assert.assertTrue((String)("Location of unit test (" + testLocation + ") not found on the classpath."), (boolean)classPath.contains(testLocation));
        } else {
            System.err.println("Unit test executed from jar file, no stable method available for testing the parsing of directory locations.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldWriteToSystemErrByDefault() {
        PrintStream originalErrStream = System.err;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            System.setErr(new PrintStream(out));
            this.enricher.printStackTrace(this.exception);
            String output = new String(out.toByteArray());
            Assert.assertTrue((String)"JUnit jar [junit not found in stack trace written to default System.err stream", (boolean)output.contains(JUNIT_JAR_PATTERN));
        }
        finally {
            System.setErr(originalErrStream);
        }
    }
}

