/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.fixtureInteraction;

import fitnesse.slim.fixtureInteraction.DefaultInteraction;
import fitnesse.slim.fixtureInteraction.MockingInteraction;
import fitnesse.slim.fixtureInteraction.Testee;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class DefaultInteractionTest {
    Class<Testee> testeeClass = Testee.class;
    Constructor<?> cstr = this.testeeClass.getConstructors()[0];
    Method setI = this.testeeClass.getMethod("setI", Integer.TYPE);
    Method getI = this.testeeClass.getMethod("getI", new Class[0]);

    @Test
    public void canCreateAndUseATestObject() throws Exception {
        Integer expectedInt = new Integer(7);
        DefaultInteraction interaction = new DefaultInteraction();
        Testee o = (Testee)interaction.newInstance(this.cstr, (Object[])null);
        interaction.methodInvoke(this.setI, (Object)o, new Object[]{expectedInt});
        Integer gotI = (Integer)interaction.methodInvoke(this.getI, (Object)o, new Object[0]);
        Assert.assertEquals((String)"should be able create an object, and use methods on a class", (Object)expectedInt, (Object)gotI);
    }

    @Test
    public void canUseMockingFramework() throws Exception {
        MockingInteraction interaction = new MockingInteraction();
        Testee testee = (Testee)interaction.newInstance(this.cstr, (Object[])null);
        interaction.methodInvoke(this.setI, (Object)testee, new Object[]{new Integer(3)});
        String gotI = (String)interaction.methodInvoke(this.getI, (Object)testee, new Object[0]);
        String expectedMockingOnlyString = "----mockingOnly----";
        Assert.assertEquals((String)"should be able create, and call setters and getters. These won't work", (Object)expectedMockingOnlyString, (Object)gotI);
    }
}

