/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import fitnesse.slim.SlimException;
import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.instructions.InstructionResult;
import fitnesse.slim.instructions.SystemExitSecurityManager;

public abstract class Instruction {
    public static final Instruction NOOP_INSTRUCTION = new /* Unavailable Anonymous Inner Class!! */;
    private String id;

    public Instruction(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InstructionResult execute(InstructionExecutor executor) {
        InstructionResult result;
        SecurityManager oldSecurityManager = System.getSecurityManager();
        System.setSecurityManager((SecurityManager)new SystemExitSecurityManager(oldSecurityManager));
        try {
            result = this.executeInternal(executor);
        }
        catch (SlimException e) {
            result = new InstructionResult.Error(this.getId(), e);
        }
        catch (SystemExitSecurityManager.SystemExitException e) {
            result = new InstructionResult.Error(this.getId(), (SecurityException)((Object)e));
        }
        finally {
            System.setSecurityManager(oldSecurityManager);
        }
        return result;
    }

    protected abstract InstructionResult executeInternal(InstructionExecutor var1) throws SlimException;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Instruction");
        sb.append("{id='").append(this.id).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Instruction)) {
            return false;
        }
        Instruction that = (Instruction)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

