/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.testsystems.TestPage;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PageListSetUpTearDownSurrounder {
    private WikiPage root;
    private List<TestPage> pageList;

    public PageListSetUpTearDownSurrounder(WikiPage root) {
        this.root = root;
    }

    public void surroundGroupsOfTestPagesWithRespectiveSetUpAndTearDowns(List<TestPage> pageList) {
        this.pageList = pageList;
        HashMap pageSetUpTearDownGroups = new HashMap();
        this.createPageSetUpTearDownGroups(pageSetUpTearDownGroups);
        pageList.clear();
        this.reinsertPagesViaSetUpTearDownGroups(pageSetUpTearDownGroups);
    }

    private void createPageSetUpTearDownGroups(Map<String, LinkedList<TestPage>> pageSetUpTearDownGroups) {
        for (TestPage page : this.pageList) {
            this.makeSetUpTearDownPageGroupForPage(page, pageSetUpTearDownGroups);
        }
    }

    private void makeSetUpTearDownPageGroupForPage(TestPage page, Map<String, LinkedList<TestPage>> pageSetUpTearDownGroups) {
        String group = this.getSetUpTearDownGroup(page.getSourcePage());
        if (pageSetUpTearDownGroups.get(group) != null) {
            LinkedList<TestPage> pageGroup = pageSetUpTearDownGroups.get(group);
            pageGroup.add(page);
        } else {
            LinkedList<TestPage> pageGroup = new LinkedList<TestPage>();
            pageGroup.add(page);
            pageSetUpTearDownGroups.put(group, pageGroup);
        }
    }

    private String getSetUpTearDownGroup(WikiPage page) {
        String setUpPath = this.getPathForSetUpTearDown(page, "SuiteSetUp");
        String tearDownPath = this.getPathForSetUpTearDown(page, "SuiteTearDown");
        return setUpPath + "," + tearDownPath;
    }

    private String getPathForSetUpTearDown(WikiPage page, String setUpTearDownName) {
        String path = null;
        WikiPage suiteSetUpTearDown = PageCrawlerImpl.getClosestInheritedPage((String)setUpTearDownName, (WikiPage)page);
        if (suiteSetUpTearDown != null) {
            path = suiteSetUpTearDown.getPageCrawler().getFullPath(suiteSetUpTearDown).toString();
        }
        return path;
    }

    private void reinsertPagesViaSetUpTearDownGroups(Map<String, LinkedList<TestPage>> pageSetUpTearDownGroups) {
        for (Map.Entry<String, LinkedList<TestPage>> entry : pageSetUpTearDownGroups.entrySet()) {
            this.insertSetUpTearDownPageGroup(entry.getKey(), entry.getValue());
        }
    }

    private void insertSetUpTearDownPageGroup(String setUpAndTearDownGroupKey, LinkedList<TestPage> pageGroup) {
        this.insertSetUpForThisGroup(setUpAndTearDownGroupKey);
        this.insertPagesOfThisGroup(pageGroup);
        this.insertTearDownForThisGroup(setUpAndTearDownGroupKey);
    }

    private void insertSetUpForThisGroup(String setUpAndTearDown) {
        String setUpPath = setUpAndTearDown.split(",")[0];
        WikiPage setUpPage = this.root.getPageCrawler().getPage(this.root, PathParser.parse((String)setUpPath));
        if (setUpPage != null) {
            this.pageList.add(new TestPage(setUpPage));
        }
    }

    private void insertPagesOfThisGroup(LinkedList<TestPage> pageGroup) {
        for (TestPage page : pageGroup) {
            this.pageList.add(page);
        }
    }

    private void insertTearDownForThisGroup(String setUpAndTearDownGroupKey) {
        String tearDownPath = setUpAndTearDownGroupKey.split(",")[1];
        WikiPage tearDownPage = this.root.getPageCrawler().getPage(this.root, PathParser.parse((String)tearDownPath));
        if (tearDownPage != null) {
            this.pageList.add(new TestPage(tearDownPage));
        }
    }
}

