/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ReadOnlyPageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.Collections;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestPage {
    public static final String TEAR_DOWN = "TearDown";
    public static final String SET_UP = "SetUp";
    private WikiPage sourcePage;
    private PageData data;
    private List<WikiPage> scenarioLibraries;
    private WikiPage setUp;
    private WikiPage tearDown;

    public TestPage(WikiPage sourcePage) {
        this.sourcePage = sourcePage;
    }

    public TestPage(PageData data) {
        this.data = data;
        this.sourcePage = data.getWikiPage();
    }

    public static boolean isTestPage(PageData pageData) {
        return pageData.hasAttribute("Test");
    }

    public WikiPage getSourcePage() {
        return this.sourcePage;
    }

    public PageData getData() {
        return this.data == null ? this.sourcePage.getData() : this.data;
    }

    public ReadOnlyPageData parsedData() {
        return this.sourcePage.readOnlyData();
    }

    public PageData getDecoratedData() {
        StringBuilder decoratedContent = new StringBuilder(1024);
        this.includeScenarioLibraries(decoratedContent);
        this.decorate(this.getSetUp(), decoratedContent);
        decoratedContent.append(this.parsedData().getContent());
        this.decorate(this.getTearDown(), decoratedContent);
        return new PageData(this.sourcePage, decoratedContent.toString());
    }

    public PageData decorate(WikiPage wikiPage) {
        StringBuilder decoratedContent = new StringBuilder(1024);
        this.decorate(wikiPage, decoratedContent);
        return new PageData(this.sourcePage, decoratedContent.toString());
    }

    protected void decorate(WikiPage wikiPage, StringBuilder decoratedContent) {
        if (wikiPage == this.getSetUp()) {
            this.includePage(wikiPage, "-setup", decoratedContent);
        } else if (wikiPage == this.getTearDown()) {
            this.includePage(wikiPage, "-teardown", decoratedContent);
        } else if (this.getScenarioLibraries().contains(wikiPage)) {
            this.includeScenarioLibrary(wikiPage, decoratedContent);
        } else {
            decoratedContent.append(wikiPage.readOnlyData().getContent());
        }
    }

    protected void includeScenarioLibraries(StringBuilder decoratedContent) {
        if (!this.getScenarioLibraries().isEmpty()) {
            decoratedContent.append("!*> Scenario Libraries\n");
            for (WikiPage scenarioLibrary : this.getScenarioLibraries()) {
                this.includeScenarioLibrary(scenarioLibrary, decoratedContent);
            }
            decoratedContent.append("*!\n");
        }
    }

    protected void includeScenarioLibrary(WikiPage scenarioLibrary, StringBuilder newPageContent) {
        newPageContent.append("!include -c .");
        newPageContent.append(this.getPathNameForPage(scenarioLibrary));
        newPageContent.append("\n");
    }

    protected void includePage(WikiPage wikiPage, String arg, StringBuilder newPageContent) {
        if (wikiPage == null) {
            return;
        }
        String pagePathName = this.getPathNameForPage(wikiPage);
        newPageContent.append("\n!include ").append(arg).append(" .").append(pagePathName).append("\n");
    }

    private String getPathNameForPage(WikiPage page) {
        PageCrawler pageCrawler = this.getSourcePage().getPageCrawler();
        WikiPagePath pagePath = pageCrawler.getFullPath(page);
        return PathParser.render((WikiPagePath)pagePath);
    }

    public String getPath() {
        return this.getPathNameForPage(this.sourcePage);
    }

    public String getName() {
        return this.sourcePage.getName();
    }

    public boolean isSlim() {
        return "slim".equalsIgnoreCase(this.parsedData().getVariable("TEST_SYSTEM"));
    }

    public boolean isTestPage() {
        return TestPage.isTestPage((PageData)this.getData());
    }

    public List<WikiPage> getScenarioLibraries() {
        if (this.scenarioLibraries == null) {
            this.scenarioLibraries = this.findScenarioLibraries();
        }
        return this.scenarioLibraries;
    }

    public WikiPage getSetUp() {
        if (this.setUp == null && !this.isSuiteSetUpOrTearDownPage()) {
            this.setUp = this.findInheritedPage("SetUp");
        }
        return this.setUp;
    }

    public WikiPage getTearDown() {
        if (this.tearDown == null && !this.isSuiteSetUpOrTearDownPage()) {
            this.tearDown = this.findInheritedPage("TearDown");
        }
        return this.tearDown;
    }

    protected boolean isSuiteSetUpOrTearDownPage() {
        return "SuiteSetUp".equals(this.getName()) || "SuiteTearDown".equals(this.getName());
    }

    protected WikiPage findInheritedPage(String pageName) {
        return PageCrawlerImpl.getClosestInheritedPage((String)pageName, (WikiPage)this.sourcePage);
    }

    private List<WikiPage> findScenarioLibraries() {
        List uncles;
        if (this.isSlim()) {
            uncles = PageCrawlerImpl.getAllUncles((String)"ScenarioLibrary", (WikiPage)this.sourcePage);
            Collections.reverse(uncles);
        } else {
            uncles = Collections.emptyList();
        }
        return uncles;
    }
}

