/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.fit;

import fitnesse.FitNesseContext;
import fitnesse.testsystems.ExecutionLog;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.fit.CommandRunningFitClient;
import fitnesse.wiki.WikiPage;
import java.io.IOException;
import java.util.Map;

public class FitTestSystem
extends TestSystem {
    protected static final String EMPTY_PAGE_CONTENT = "OH NO! This page is empty!";
    private CommandRunningFitClient client;
    private FitNesseContext context;
    private final TestSystem.Descriptor descriptor;

    public FitTestSystem(FitNesseContext context, WikiPage page, TestSystem.Descriptor descriptor, TestSystemListener listener) {
        super(page, listener);
        this.descriptor = descriptor;
        this.context = context;
    }

    public void bye() throws IOException, InterruptedException {
        this.client.done();
        this.client.join();
    }

    public void runTests(TestPage pageToTest) throws IOException, InterruptedException {
        String html = pageToTest.getDecoratedData().getHtml();
        if (html.length() == 0) {
            this.client.send(EMPTY_PAGE_CONTENT);
        } else {
            this.client.send(html);
        }
    }

    public boolean isSuccessfullyStarted() {
        return this.client.isSuccessfullyStarted();
    }

    public void kill() {
        this.client.kill();
    }

    public void start() {
        String command = this.buildCommand(this.descriptor);
        Map environmentVariables = this.createClasspathEnvironment(this.descriptor.getClassPath());
        CommandRunningFitClient.InProcessCommandRunner runningStrategy = this.fastTest ? new CommandRunningFitClient.InProcessCommandRunner(this.descriptor) : new CommandRunningFitClient.OutOfProcessCommandRunner(command, environmentVariables);
        this.client = new CommandRunningFitClient((TestSystemListener)this, this.context.port, this.context.socketDealer, (CommandRunningFitClient.CommandRunningStrategy)runningStrategy);
        this.setExecutionLog(new ExecutionLog(this.page, this.client.commandRunner));
        this.client.start();
    }
}

