/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.slim.HtmlTable;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.ExceptionResult;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.SyntaxError;
import fitnesse.wikitext.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.htmlparser.Node;
import org.htmlparser.Tag;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.TableColumn;
import org.htmlparser.tags.TableHeader;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class HtmlTable
implements Table {
    private List<Row> rows = new ArrayList();
    private TableTag tableNode;

    public HtmlTable(TableTag tableNode) {
        this.tableNode = tableNode;
        NodeList nodeList = tableNode.getChildren();
        for (int i = 0; i < nodeList.size(); ++i) {
            Node node = nodeList.elementAt(i);
            if (!(node instanceof TableRow) && !(node instanceof TableHeader)) continue;
            this.rows.add(new Row(this, (CompositeTag)node));
        }
    }

    public TableTag getTableNode() {
        return this.tableNode;
    }

    public String getCellContents(int columnIndex, int rowIndex) {
        return ((Row)this.rows.get(rowIndex)).getColumn(columnIndex).getContent();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCountInRow(int rowIndex) {
        return ((Row)this.rows.get(rowIndex)).getColumnCount();
    }

    public void substitute(int col, int row, String contents) {
        Cell cell = ((Row)this.rows.get(row)).getColumn(col);
        Cell.access$000((Cell)cell, (String)contents);
    }

    public List<List<String>> asList() {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (Row row : this.rows) {
            list.add(Row.access$100((Row)row));
        }
        return list;
    }

    public String toString() {
        return this.asList().toString();
    }

    public String toHtml() {
        return this.tableNode.toHtml();
    }

    public int addRow(List<String> list) {
        Row row = new Row(this);
        this.rows.add(row);
        this.tableNode.getChildren().add((Node)row.getRowNode());
        for (String s : list) {
            row.appendCell(s == null ? "" : Utils.escapeHTML((String)s));
        }
        return this.rows.size() - 1;
    }

    public void addColumnToRow(int rowIndex, String contents) {
        Row row = (Row)this.rows.get(rowIndex);
        row.appendCell(Utils.escapeHTML((String)contents));
    }

    public void appendChildTable(int rowIndex, Table childTable) {
        Row row = (Row)this.rows.get(rowIndex);
        Row childRow = this.makeChildRow(row, (Node)((HtmlTable)childTable).getTableNode(), "scenario");
        this.insertRowAfter(row, childRow);
    }

    private Row makeChildRow(Row row, Node contents, String type) {
        Row childRow = new Row(this);
        TableColumn column = (TableColumn)this.newTag(TableColumn.class);
        column.setChildren(new NodeList(contents));
        column.setAttribute("colspan", "" + this.colspan(row), '\"');
        Row.access$200((Row)childRow, (Cell)new Cell(this, column));
        Row.access$300((Row)row).setAttribute("class", type + " closed", '\"');
        Row.access$300((Row)childRow).setAttribute("class", type + "-detail closed-detail", '\"');
        return childRow;
    }

    private int colspan(Row row) {
        NodeList rowNodes = Row.access$300((Row)row).getChildren();
        int colspan = 0;
        for (int i = 0; i < rowNodes.size(); ++i) {
            if (!(rowNodes.elementAt(i) instanceof TableColumn)) continue;
            String s = ((TableColumn)rowNodes.elementAt(i)).getAttribute("colspan");
            if (s != null) {
                colspan += Integer.parseInt(s);
                continue;
            }
            ++colspan;
        }
        return colspan;
    }

    private void insertRowAfter(Row existingRow, Row childRow) {
        NodeList rowNodes = this.tableNode.getChildren();
        int index = rowNodes.indexOf((Node)Row.access$300((Row)existingRow));
        Stack<Node> tempStack = new Stack<Node>();
        while (rowNodes.size() - 1 > index) {
            tempStack.push(rowNodes.elementAt(this.tableNode.getChildren().size() - 1));
            rowNodes.remove(rowNodes.size() - 1);
        }
        rowNodes.add((Node)Row.access$300((Row)childRow));
        while (tempStack.size() > 0) {
            rowNodes.add((Node)tempStack.pop());
        }
    }

    public void updateContent(int rowIndex, TestResult testResult) {
        Row.access$400((Row)((Row)this.rows.get(rowIndex)), (ExecutionResult)testResult.getExecutionResult());
    }

    public void updateContent(int col, int row, TestResult testResult) {
        Cell cell = ((Row)this.rows.get(row)).getColumn(col);
        cell.setTestResult(testResult);
        Cell.access$000((Cell)cell, (String)cell.formatTestResult());
    }

    public void updateContent(int colIndex, int rowIndex, ExceptionResult exceptionResult) {
        Row row = (Row)this.rows.get(rowIndex);
        Cell cell = row.getColumn(colIndex);
        if (exceptionResult.hasMessage()) {
            cell.setExceptionResult(exceptionResult);
        } else {
            Row childRow = this.makeChildRow(row, (Node)new TextNode("<pre>" + Utils.escapeHTML((String)exceptionResult.getException()) + "</pre>"), "exception");
            this.insertRowAfter(row, childRow);
            Row.access$400((Row)row, (ExecutionResult)exceptionResult.getExecutionResult());
        }
    }

    private Tag newTag(Class<? extends Tag> klass) {
        Tag tag = null;
        try {
            tag = klass.newInstance();
            tag.setTagName(tag.getTagName().toLowerCase());
            Tag endTag = klass.newInstance();
            endTag.setTagName("/" + tag.getTagName().toLowerCase());
            endTag.setParent((Node)tag);
            tag.setEndTag(endTag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tag;
    }

    public HtmlTable asTemplate(Table.CellContentSubstitution substitution) throws SyntaxError {
        String script = this.toHtml();
        script = substitution.substitute(0, 0, script);
        return new HtmlTableScanner(script).getTable(0);
    }

    static /* synthetic */ Tag access$500(HtmlTable x0, Class x1) {
        return x0.newTag(x1);
    }
}

