/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.slim.HtmlSlimTestSystem;
import fitnesse.testsystems.slim.SlimTestSystem;
import fitnesse.testsystems.slim.SlimTestSystemTest;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.net.ServerSocket;
import java.net.SocketException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SlimTestSystemTest {
    private WikiPage root;
    private PageCrawler crawler;
    private TestSystemListener dummyListener = new DummyListener();

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.crawler = this.root.getPageCrawler();
        SlimTestSystem.SlimDescriptor.clearSlimPortOffset();
    }

    @Test
    public void portRotates() throws Exception {
        for (int i = 1; i < 15; ++i) {
            SlimTestSystem.SlimDescriptor descriptor = new SlimTestSystem.SlimDescriptor(TestSystem.getDescriptor((WikiPage)this.root, null, (boolean)false));
            Assert.assertEquals((long)(8085 + i % 10), (long)descriptor.getSlimPort());
        }
    }

    @Test
    public void portStartsAtSlimPortVariable() throws Exception {
        WikiPage pageWithSlimPortDefined = this.crawler.addPage(this.root, PathParser.parse((String)"PageWithSlimPortDefined"), "!define SLIM_PORT {9000}\n");
        for (int i = 1; i < 15; ++i) {
            SlimTestSystem.SlimDescriptor descriptor = new SlimTestSystem.SlimDescriptor(TestSystem.getDescriptor((WikiPage)pageWithSlimPortDefined, null, (boolean)false));
            Assert.assertEquals((long)(9000 + i % 10), (long)descriptor.getSlimPort());
        }
    }

    @Test
    public void badSlimPortVariableDefaults() throws Exception {
        WikiPage pageWithBadSlimPortDefined = this.crawler.addPage(this.root, PathParser.parse((String)"PageWithBadSlimPortDefined"), "!define SLIM_PORT {BOB}\n");
        for (int i = 1; i < 15; ++i) {
            Assert.assertEquals((long)(8085 + i % 10), (long)new SlimTestSystem.SlimDescriptor(TestSystem.getDescriptor((WikiPage)pageWithBadSlimPortDefined, null, (boolean)false)).getSlimPort());
        }
    }

    @Test
    public void slimHostDefaultsTolocalhost() throws Exception {
        WikiPage pageWithoutSlimHostVariable = this.crawler.addPage(this.root, PathParser.parse((String)"PageWithoutSlimHostVariable"), "some gunk\n");
        Assert.assertEquals((Object)"localhost", (Object)new SlimTestSystem.SlimDescriptor(TestSystem.getDescriptor((WikiPage)pageWithoutSlimHostVariable, null, (boolean)false)).determineSlimHost());
    }

    @Test
    public void slimHostVariableSetsTheHost() throws Exception {
        WikiPage pageWithSlimHostVariable = this.crawler.addPage(this.root, PathParser.parse((String)"PageWithSlimHostVariable"), "!define SLIM_HOST {somehost}\n");
        Assert.assertEquals((Object)"somehost", (Object)new SlimTestSystem.SlimDescriptor(TestSystem.getDescriptor((WikiPage)pageWithSlimHostVariable, null, (boolean)false)).determineSlimHost());
    }

    @Test
    public void translateExceptionMessage() throws Exception {
        this.assertTranslatedException("Could not find constructor for SomeClass", "NO_CONSTRUCTOR SomeClass");
        this.assertTranslatedException("Could not invoke constructor for SomeClass", "COULD_NOT_INVOKE_CONSTRUCTOR SomeClass");
        this.assertTranslatedException("No converter for SomeClass", "NO_CONVERTER_FOR_ARGUMENT_NUMBER SomeClass");
        this.assertTranslatedException("Method someMethod not found in SomeClass", "NO_METHOD_IN_CLASS someMethod SomeClass");
        this.assertTranslatedException("The instance someInstance does not exist", "NO_INSTANCE someInstance");
        this.assertTranslatedException("Could not find class SomeClass", "NO_CLASS SomeClass");
        this.assertTranslatedException("The instruction [a, b, c] is malformed", "MALFORMED_INSTRUCTION [a, b, c]");
    }

    private void assertTranslatedException(String expected, String message) {
        Assert.assertEquals((Object)expected, (Object)SlimTestSystem.translateExceptionMessage((String)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=SocketException.class)
    public void createSlimServiceFailsFastWhenSlimPortIsNotAvailable() throws Exception {
        int slimServerPort = 10258;
        ServerSocket slimSocket = new ServerSocket(10258);
        try {
            TestSystem.Descriptor descriptor = HtmlSlimTestSystem.getDescriptor((WikiPage)this.root, null, (boolean)false);
            HtmlSlimTestSystem sys = new HtmlSlimTestSystem(this.root, descriptor, this.dummyListener);
            String slimArguments = String.format("%s %d", "", 10258);
            sys.createSlimService(slimArguments);
        }
        finally {
            slimSocket.close();
        }
    }
}

