/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.DecisionTable;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.util.List;

public class DecisionTable
extends SlimTable {
    private static final String instancePrefix = "decisionTable";

    public DecisionTable(Table table, String id, SlimTestContext context) {
        super(table, id, context);
    }

    protected String getTableType() {
        return instancePrefix;
    }

    public List<Assertion> getAssertions() throws SyntaxError {
        if (this.table.getRowCount() == 2) {
            throw new SyntaxError("DecisionTables should have at least three rows.");
        }
        String scenarioName = this.getScenarioName();
        ScenarioTable scenario = this.getTestContext().getScenario(scenarioName);
        if (scenario != null) {
            return new ScenarioCaller(this, null).call(scenario);
        }
        return new FixtureCaller(this, null).call(this.getFixtureName());
    }

    private String getScenarioName() {
        StringBuffer nameBuffer = new StringBuffer();
        for (int nameCol = 0; nameCol < this.table.getColumnCountInRow(0); nameCol += 2) {
            if (nameCol == 0) {
                nameBuffer.append(this.getFixtureName(this.table.getCellContents(nameCol, 0)));
            } else {
                nameBuffer.append(this.table.getCellContents(nameCol, 0));
            }
            nameBuffer.append(" ");
        }
        return SlimTable.Disgracer.disgraceClassName((String)nameBuffer.toString().trim());
    }

    protected Instruction callAndAssign(String symbolName, String functionName) {
        return this.callAndAssign(symbolName, this.getTableName(), functionName, new String[0]);
    }
}

