/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.ImportInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.Expectation;
import fitnesse.testsystems.slim.tables.ImportTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.util.ArrayList;
import java.util.List;

public class ImportTable
extends SlimTable {
    public ImportTable(Table table, String id, SlimTestContext testContext) {
        super(table, id, testContext);
    }

    protected String getTableType() {
        return "import";
    }

    public List<Assertion> getAssertions() throws SyntaxError {
        int rows = this.table.getRowCount();
        ArrayList<Assertion> instructions = new ArrayList<Assertion>(rows);
        if (rows < 2) {
            throw new SyntaxError("Import tables must have at least two rows.");
        }
        for (int row = 1; row < rows; ++row) {
            String importString = this.table.getCellContents(0, row);
            if (importString.length() <= 0) continue;
            ImportInstruction importInstruction = new ImportInstruction(this.makeInstructionTag(), importString);
            instructions.add(this.makeAssertion((Instruction)importInstruction, (Expectation)new ImportExpectation(this, 0, row)));
        }
        return instructions;
    }
}

