/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.Expectation;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.TableTable;
import java.util.ArrayList;
import java.util.List;
import util.ListUtility;

public class TableTable
extends SlimTable {
    private String doTableId;

    public TableTable(Table table, String tableId, SlimTestContext slimTestContext) {
        super(table, tableId, slimTestContext);
    }

    protected String getTableType() {
        return "tableTable";
    }

    public List<Assertion> getAssertions() {
        Assertion make = this.constructFixture(this.getFixtureName());
        Instruction doTable = this.callFunction(this.getTableName(), "doTable", new Object[]{this.tableAsList()});
        this.doTableId = doTable.getId();
        return ListUtility.list((Object[])new Assertion[]{make, this.makeAssertion(doTable, (Expectation)new TableTableExpectation(this))});
    }

    private TestSummary resizeTableAndEvaluateRows(Object returnValue) {
        List tableResults = (List)returnValue;
        this.extendTable(this.table, tableResults);
        TestSummary testSummary = new TestSummary();
        for (int row = 0; row < tableResults.size(); ++row) {
            this.evaluateRow(tableResults, row, testSummary);
        }
        return testSummary;
    }

    private void extendTable(Table table, List<List<Object>> tableResults) {
        this.addNewRows(table, tableResults);
        this.extendExistingRows(table, tableResults);
    }

    private void addNewRows(Table table, List<List<Object>> tableResults) {
        while (table.getRowCount() - 1 < tableResults.size()) {
            ArrayList<String> l = new ArrayList<String>();
            for (Object s : tableResults.get(table.getRowCount() - 1)) {
                l.add((String)s);
            }
            table.addRow(l);
        }
    }

    private void extendExistingRows(Table table, List<List<Object>> tableResults) {
        for (int row = 1; row < tableResults.size(); ++row) {
            this.extendRow(table, row, tableResults.get(row - 1));
        }
    }

    private void extendRow(Table table, int row, List<Object> cellList) {
        while (table.getColumnCountInRow(row) < cellList.size()) {
            table.addColumnToRow(row, (String)cellList.get(table.getColumnCountInRow(row)));
        }
    }

    private void evaluateRow(List<List<Object>> tableResults, int resultRow, TestSummary testSummary) {
        List<Object> rowList = tableResults.get(resultRow);
        for (int col = 0; col < rowList.size(); ++col) {
            int tableRow = resultRow + 1;
            String contents = this.table.getCellContents(col, tableRow);
            String result = (String)rowList.get(col);
            TestResult testResult = this.getTestResult(result, this.replaceSymbolsWithFullExpansion(contents));
            if (testResult == null) continue;
            this.table.updateContent(col, tableRow, testResult);
            testSummary.add(testResult.getExecutionResult());
        }
    }

    private TestResult getTestResult(String message, String content) {
        TestResult result;
        if (message.equalsIgnoreCase("no change") || message.length() == 0) {
            return null;
        }
        if (message.equalsIgnoreCase("pass")) {
            result = TestResult.pass((String)content);
        } else if (message.equalsIgnoreCase("fail")) {
            result = TestResult.fail((String)content);
        } else if (message.equalsIgnoreCase("ignore")) {
            result = TestResult.ignore();
        } else {
            result = this.resultFromMessage(message);
            if (result == null) {
                result = TestResult.fail((String)message);
            }
        }
        return result;
    }

    private TestResult resultFromMessage(String contents) {
        int colon = contents.indexOf(":");
        if (colon == -1) {
            return null;
        }
        String code = contents.substring(0, colon);
        String message = contents.substring(colon + 1);
        if (code.equalsIgnoreCase("error")) {
            return TestResult.error((String)message);
        }
        if (code.equalsIgnoreCase("fail")) {
            return TestResult.fail((String)message);
        }
        if (code.equalsIgnoreCase("pass")) {
            return TestResult.pass((String)message);
        }
        if (code.equalsIgnoreCase("ignore")) {
            return TestResult.ignore((String)message);
        }
        if (code.equalsIgnoreCase("report")) {
            return TestResult.plain((String)message);
        }
        return null;
    }

    static /* synthetic */ TestSummary access$000(TableTable x0, Object x1) {
        return x0.resizeTableAndEvaluateRows(x1);
    }
}

