/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import java.util.List;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class PageDataTest
extends RegexTestCase {
    public WikiPage page;
    private WikiPage root;
    private PageCrawler crawler;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"PagE"), "some content");
    }

    public void tearDown() throws Exception {
    }

    public void testVariablePreprocessing() throws Exception {
        PageData d = new PageData(InMemoryPage.makeRoot((String)"RooT"), "!define x {''italic''}\n${x}\n");
        String preprocessedText = d.getContent();
        PageDataTest.assertHasRegexp((String)"''italic''", (String)preprocessedText);
    }

    public void testVariablesRenderedFirst() throws Exception {
        String text = "!define x {''italics''}\n${x}";
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        WikiPage page = this.crawler.addPage(root, PathParser.parse((String)"SomePage"), text);
        String html = page.getData().getHtml();
        PageDataTest.assertHasRegexp((String)"''italics''", (String)html);
        PageDataTest.assertHasRegexp((String)"<i>italics</i>", (String)html);
    }

    public void testVariablesWithinVariablesAreResolved() throws Exception {
        String text = "!define x {b}\n!define y (a${x}c)\n${y}";
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        WikiPage page = this.crawler.addPage(root, PathParser.parse((String)"SomePage"), text);
        String html = page.getData().getHtml();
        PageDataTest.assertHasRegexp((String)"abc", (String)html);
        PageDataTest.assertHasRegexp((String)"variable defined: y=a\\$\\{x\\}c", (String)html);
        String variableContents = page.getData().getVariable("y");
        PageDataTest.assertEquals((String)"abc", (String)variableContents);
    }

    public void testThatSpecialCharsAreNotEscapedTwice() throws Exception {
        PageData d = new PageData((WikiPage)new WikiPageDummy(), "<b>");
        String html = d.getHtml();
        PageDataTest.assertEquals((String)"&lt;b&gt;", (String)html);
    }

    public void testLiteral() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        WikiPage page = this.crawler.addPage(root, PathParser.parse((String)"LiteralPage"), "!-literal-!");
        String renderedContent = page.getData().getHtml();
        PageDataTest.assertHasRegexp((String)"literal", (String)renderedContent);
        PageDataTest.assertDoesntHaveRegexp((String)"!-literal-!", (String)renderedContent);
    }

    public void testClasspath() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        WikiPage page = this.crawler.addPage(root, PathParser.parse((String)"ClassPath"), "!path 123\n!path abc\n");
        List paths = page.getData().getClasspaths();
        PageDataTest.assertTrue((boolean)paths.contains("123"));
        PageDataTest.assertTrue((boolean)paths.contains("abc"));
    }

    public void testClasspathWithVariable() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        WikiPage page = this.crawler.addPage(root, PathParser.parse((String)"ClassPath"), "!define PATH {/my/path}\n!path ${PATH}.jar");
        List paths = page.getData().getClasspaths();
        PageDataTest.assertEquals((String)"/my/path.jar", (String)paths.get(0).toString());
        PageData data = root.getData();
        data.setContent("!define PATH {/my/path}\n");
        root.commit(data);
        page = this.crawler.addPage(root, PathParser.parse((String)"ClassPath2"), "!path ${PATH}.jar");
        paths = page.getData().getClasspaths();
        PageDataTest.assertEquals((String)"/my/path.jar", (String)paths.get(0).toString());
    }

    public void testClasspathWithVariableDefinedInIncludedPage() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler.addPage(root, PathParser.parse((String)"VariablePage"), "!define PATH {/my/path}\n");
        WikiPage page = this.crawler.addPage(root, PathParser.parse((String)"ClassPath"), "!include VariablePage\n!path ${PATH}.jar");
        List paths = page.getData().getClasspaths();
        PageDataTest.assertEquals((String)"/my/path.jar", (String)paths.get(0).toString());
    }

    public void testVariableIgnoredInParentPreformatted() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        WikiPage parent = this.crawler.addPage(root, PathParser.parse((String)"VariablePage"), "{{{\n!define SOMEVAR {A VALUE}\n}}}\n");
        WikiPage child = this.crawler.addPage(parent, PathParser.parse((String)"ChildPage"), "${SOMEVAR}\n");
        String renderedContent = child.getData().getHtml();
        PageDataTest.assertHasRegexp((String)"undefined variable", (String)renderedContent);
    }

    public void testGetCrossReferences() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        WikiPage page = this.crawler.addPage(root, PathParser.parse((String)"PageName"), "!see XrefPage\r\n");
        List xrefs = page.getData().getXrefPages();
        PageDataTest.assertEquals((Object)"XrefPage", xrefs.get(0));
    }

    public void testThatExamplesAtEndOfNameSetsSuiteProperty() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"PageExamples"));
        PageData data = new PageData(page);
        PageDataTest.assertTrue((boolean)data.hasAttribute(PageType.SUITE.toString()));
    }

    public void testThatExampleAtBeginningOfNameSetsTestProperty() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"ExamplePageExample"));
        PageData data = new PageData(page);
        PageDataTest.assertTrue((boolean)data.hasAttribute(PageType.TEST.toString()));
    }

    public void testThatExampleAtEndOfNameSetsTestProperty() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"PageExample"));
        PageData data = new PageData(page);
        PageDataTest.assertTrue((boolean)data.hasAttribute(PageType.TEST.toString()));
    }

    public void testThatSuiteAtBeginningOfNameSetsSuiteProperty() throws Exception {
        WikiPage suitePage1 = this.crawler.addPage(this.root, PathParser.parse((String)"SuitePage"));
        PageData data = new PageData(suitePage1);
        PageDataTest.assertFalse((boolean)data.hasAttribute(PageType.TEST.toString()));
        PageDataTest.assertTrue((boolean)data.hasAttribute(PageType.SUITE.toString()));
    }

    public void testThatSuiteAtEndOfNameSetsSuiteProperty() throws Exception {
        WikiPage suitePage2 = this.crawler.addPage(this.root, PathParser.parse((String)"PageSuite"));
        PageData data = new PageData(suitePage2);
        PageDataTest.assertFalse((boolean)data.hasAttribute(PageType.TEST.toString()));
        PageDataTest.assertTrue((boolean)data.hasAttribute(PageType.SUITE.toString()));
    }

    public void testThatTestAtBeginningOfNameSetsTestProperty() throws Exception {
        WikiPage testPage1 = this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"));
        PageData data = new PageData(testPage1);
        PageDataTest.assertTrue((boolean)data.hasAttribute(PageType.TEST.toString()));
        PageDataTest.assertFalse((boolean)data.hasAttribute(PageType.SUITE.toString()));
    }

    public void testThatTestAtEndOfNameSetsTestProperty() throws Exception {
        WikiPage testPage2 = this.crawler.addPage(this.root, PathParser.parse((String)"PageTest"));
        PageData data = new PageData(testPage2);
        PageDataTest.assertTrue((boolean)data.hasAttribute(PageType.TEST.toString()));
        PageDataTest.assertFalse((boolean)data.hasAttribute(PageType.SUITE.toString()));
    }

    public void testDefaultAttributes() throws Exception {
        WikiPage normalPage = this.crawler.addPage(this.root, PathParser.parse((String)"NormalPage"));
        WikiPage suitePage3 = this.crawler.addPage(this.root, PathParser.parse((String)"TestPageSuite"));
        WikiPage errorLogsPage = this.crawler.addPage(this.root, PathParser.parse((String)"ErrorLogs.TestPage"));
        WikiPage suiteSetupPage = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"));
        WikiPage suiteTearDownPage = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"));
        PageData data = new PageData(normalPage);
        PageDataTest.assertTrue((boolean)data.hasAttribute("Edit"));
        PageDataTest.assertTrue((boolean)data.hasAttribute("Search"));
        PageDataTest.assertTrue((boolean)data.hasAttribute("Versions"));
        PageDataTest.assertTrue((boolean)data.hasAttribute("Files"));
        PageDataTest.assertFalse((boolean)data.hasAttribute(PageType.TEST.toString()));
        PageDataTest.assertFalse((boolean)data.hasAttribute(PageType.SUITE.toString()));
        data = new PageData(suitePage3);
        PageDataTest.assertFalse((boolean)data.hasAttribute(PageType.TEST.toString()));
        PageDataTest.assertTrue((boolean)data.hasAttribute(PageType.SUITE.toString()));
        data = new PageData(errorLogsPage);
        PageDataTest.assertFalse((boolean)data.hasAttribute(PageType.TEST.toString()));
        PageDataTest.assertFalse((boolean)data.hasAttribute(PageType.SUITE.toString()));
        data = new PageData(suiteSetupPage);
        PageDataTest.assertFalse((boolean)data.hasAttribute(PageType.SUITE.toString()));
        data = new PageData(suiteTearDownPage);
        PageDataTest.assertFalse((boolean)data.hasAttribute(PageType.SUITE.toString()));
    }

    public void testAttributesAreTruelyCopiedInCopyConstructor() throws Exception {
        PageData data = this.root.getData();
        data.setAttribute("LastModifyingUser", "Joe");
        PageData newData = new PageData(data);
        newData.setAttribute("LastModifyingUser", "Jane");
        PageDataTest.assertEquals((String)"Joe", (String)data.getAttribute("LastModifyingUser"));
    }

    public void testAllowsContentContainingCarriageReturns() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        String content = "|a|\n|table|";
        WikiPage pageWithUnixLineEndings = this.crawler.addPage(root, PathParser.parse((String)"PageName"), content);
        String contentWithCarriageReturns = content.replaceAll("\n", "\r\n");
        WikiPage pageWithDosLineEndings = this.crawler.addPage(root, PathParser.parse((String)"PageName2"), contentWithCarriageReturns);
        PageDataTest.assertEquals((String)pageWithUnixLineEndings.getData().getHtml(), (String)pageWithDosLineEndings.getData().getHtml());
    }
}

